/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.ArticleService;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Article;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ArticlesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticlesController.class);
    LanguageSortingHelper languageSortingHelper;
    LocaleRepository localeRepository;
    ArticleService service;

    @Autowired
    public ArticlesController(LanguageSortingHelper languageSortingHelper, LocaleRepository localeRepository, ArticleService service) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeRepository = localeRepository;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "articles";
    }

    @GetMapping(value={"/articles/new"})
    public String create(Model model) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        return "articles/create";
    }

    @GetMapping(value={"/api/articles/new"})
    @ResponseBody
    public Article create() {
        return (Article)this.service.create();
    }

    @GetMapping(value={"/articles/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Article article = (Article)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, article.getLabel().getLocales());
        model.addAttribute("activeLanguage", existingLanguages.get(0));
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)article.getUuid());
        return "articles/edit";
    }

    @GetMapping(value={"/api/articles/{uuid}"})
    @ResponseBody
    public Article get(@PathVariable UUID uuid) {
        return (Article)this.service.get(uuid);
    }

    @GetMapping(value={"/articles"})
    public String list(Model model, @PageableDefault(sort={"lastModified"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/articles"));
        return "articles/list";
    }

    @PostMapping(value={"/api/articles/new"})
    public ResponseEntity save(@RequestBody Article article) throws IdentifiableServiceException {
        try {
            Article articleDb = (Article)this.service.save((Identifiable)article);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)articleDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save article: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/articles/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Article article) throws IdentifiableServiceException {
        try {
            Article articleDb = (Article)this.service.update((Identifiable)article);
            return ResponseEntity.ok((Object)articleDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save article with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/articles/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Article article = (Article)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, article.getLabel().getLocales());
        model.addAttribute("article", (Object)article);
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        List relatedFileResources = this.service.getRelatedFileResources((Entity)article);
        model.addAttribute("relatedFileResources", (Object)relatedFileResources);
        return "articles/view";
    }
}

