/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.model.api.security.User;
import de.digitalcollections.model.impl.security.UserImpl;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"user"})
public class SetupController
extends AbstractController
implements MessageSourceAware {
    private MessageSource messageSource;
    @Autowired
    UserService userService;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ModelAttribute(value="createAdmin")
    public boolean adminFlag() {
        return true;
    }

    @RequestMapping(value={"/setup/adminUser"}, method={RequestMethod.GET})
    public String adminUser(Model model) {
        model.addAttribute("user", (Object)this.userService.createAdminUser());
        return "users/create";
    }

    @RequestMapping(value={"/setup/adminUser"}, method={RequestMethod.POST})
    public String adminUser(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid UserImpl user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/create";
        }
        this.userService.create((User)user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/create";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/";
    }
}

