/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.cudami.admin.business.api.service.LocaleService;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.resource.WebpageService;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.resource.Webpage;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"webpage"})
public class WebpagesController
extends AbstractController
implements MessageSourceAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpagesController.class);
    private MessageSource messageSource;
    @Autowired
    LocaleService localeService;
    @Autowired
    WebpageService webpageService;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "webpages";
    }

    @RequestMapping(value={"/webpages/new"}, method={RequestMethod.GET})
    public String create(Model model, @RequestParam(value="websiteUuid") String websiteUuid) {
        model.addAttribute("webpage", (Object)this.webpageService.create());
        model.addAttribute("isNew", (Object)true);
        model.addAttribute("locales", (Object)this.localeService.findAll());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        model.addAttribute("websiteUuid", (Object)websiteUuid);
        return "webpages/edit";
    }

    @RequestMapping(value={"/webpages/new"}, method={RequestMethod.POST})
    public String create(@ModelAttribute @Valid Webpage webpage, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes, @RequestParam(value="websiteUuid") UUID websiteUuid) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)true);
            return "webpages/edit";
        }
        Webpage webpageDb = null;
        try {
            webpageDb = this.webpageService.save(webpage, websiteUuid, (Errors)results);
            LOGGER.info("Successfully saved webpage");
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage: ", (Throwable)e);
            String message = this.messageSource.getMessage("msg.error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/websites";
        }
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)true);
            return "webpages/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/webpages/" + webpageDb.getUuid().toString();
    }

    @RequestMapping(value={"/webpages/{uuid}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        Webpage webpage = (Webpage)this.webpageService.get(uuid);
        model.addAttribute("availableLocales", (Object)webpage.getLabel().getLocales());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        model.addAttribute("webpage", (Object)webpage);
        model.addAttribute("isNew", (Object)false);
        model.addAttribute("locales", (Object)this.localeService.findAll());
        return "webpages/edit";
    }

    @RequestMapping(value={"/webpages/{pathUuid}/edit"}, method={RequestMethod.POST})
    public String edit(@PathVariable UUID pathUuid, @ModelAttribute @Valid Webpage webpage, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)false);
            return "webpages/edit";
        }
        try {
            Webpage webpageDb = (Webpage)this.webpageService.get(pathUuid);
            webpageDb.setLabel(webpage.getLabel());
            webpageDb.setDescription(webpage.getDescription());
            webpageDb.setText(webpage.getText());
            webpage = (Webpage)this.webpageService.update((Identifiable)webpageDb, (Errors)results);
        }
        catch (IdentifiableServiceException e) {
            String message = "Cannot save webpage with uuid=" + pathUuid + ": " + (Object)((Object)e);
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/webpages/" + pathUuid + "/edit";
        }
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)false);
            return "webpages/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/webpages/" + pathUuid;
    }

    @RequestMapping(value={"/webpages"}, method={RequestMethod.GET})
    public String list(Model model, @PageableDefault(sort={"email"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.webpageService.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/webpages"));
        return "webpages/list";
    }

    @RequestMapping(value={"/webpages/{uuid}"}, method={RequestMethod.GET})
    public String view(@PathVariable UUID uuid, Model model) {
        Webpage webpage = (Webpage)this.webpageService.get(uuid);
        model.addAttribute("availableLocales", (Object)webpage.getLabel().getLocales());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        model.addAttribute("webpage", (Object)webpage);
        return "webpages/view";
    }

    public void setWebpageService(WebpageService webpageService) {
        this.webpageService = webpageService;
    }
}

