/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.cudami.admin.business.api.service.LocaleService;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.WebsiteService;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.entity.Website;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"website"})
public class WebsitesController
extends AbstractController
implements MessageSourceAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitesController.class);
    private MessageSource messageSource;
    @Autowired
    LocaleService localeService;
    @Autowired
    WebsiteService websiteService;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "websites";
    }

    @RequestMapping(value={"/websites/new"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("website", (Object)this.websiteService.create());
        model.addAttribute("isNew", (Object)true);
        model.addAttribute("locales", (Object)this.localeService.findAll());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        return "websites/edit";
    }

    @RequestMapping(value={"/websites/new"}, method={RequestMethod.POST})
    public String create(@ModelAttribute @Valid Website website, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)true);
            return "websites/edit";
        }
        try {
            this.websiteService.save((Identifiable)website, (Errors)results);
            LOGGER.info("Successfully saved website");
        }
        catch (Exception e) {
            LOGGER.error("Cannot save website: ", (Throwable)e);
            String message = this.messageSource.getMessage("msg.error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/websites";
        }
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)true);
            return "websites/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/websites";
    }

    @RequestMapping(value={"/websites/{uuid}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        Website website = (Website)this.websiteService.get(uuid);
        model.addAttribute("website", (Object)website);
        model.addAttribute("isNew", (Object)false);
        model.addAttribute("availableLocales", (Object)website.getLabel().getLocales());
        model.addAttribute("locales", (Object)this.localeService.findAll());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        return "websites/edit";
    }

    @RequestMapping(value={"/websites/{pathUuid}/edit"}, method={RequestMethod.POST})
    public String edit(@PathVariable UUID pathUuid, @ModelAttribute @Valid Website website, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)false);
            return "websites/edit";
        }
        try {
            Website websiteDb = (Website)this.websiteService.get(pathUuid);
            websiteDb.setUrl(website.getUrl());
            websiteDb.setLabel(website.getLabel());
            websiteDb.setDescription(website.getDescription());
            this.websiteService.update((Identifiable)websiteDb, (Errors)results);
        }
        catch (IdentifiableServiceException e) {
            String message = "Cannot save website with uuid=" + pathUuid + ": " + (Object)((Object)e);
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/websites/" + pathUuid + "/edit";
        }
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)false);
            return "websites/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/websites/" + pathUuid;
    }

    @RequestMapping(value={"/websites"}, method={RequestMethod.GET})
    public String list(Model model, @PageableDefault(sort={"email"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.websiteService.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        model.addAttribute("page", (Object)new PageWrapper(page, "/websites"));
        return "websites/list";
    }

    @RequestMapping(value={"/websites/{uuid}"}, method={RequestMethod.GET})
    public String view(@PathVariable UUID uuid, Model model) {
        Website website = (Website)this.websiteService.get(uuid);
        model.addAttribute("availableLocales", (Object)website.getLabel().getLocales());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        model.addAttribute("website", (Object)website);
        return "websites/view";
    }

    public void setWebsiteService(WebsiteService websiteService) {
        this.websiteService = websiteService;
    }
}

