/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.WebpageService;
import de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity.parts.EntityPartServiceImpl;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebpageServiceImpl<E extends Entity>
extends EntityPartServiceImpl<Webpage, E>
implements WebpageService<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);

    @Autowired
    public WebpageServiceImpl(WebpageRepository<E> repository) {
        super(repository);
    }

    @Override
    public List<Webpage> getChildren(Webpage webpage) {
        return ((NodeRepository)this.repository).getChildren((Node)webpage);
    }

    @Override
    public List<Webpage> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public Webpage getParent(Webpage webpage) {
        return this.getParent(webpage.getUuid());
    }

    @Override
    public Webpage getParent(UUID webpageUuid) {
        return (Webpage)((WebpageRepository)this.repository).getParent(webpageUuid);
    }

    @Override
    public Website getWebsite(UUID webpageUuid) {
        return ((WebpageRepository)this.repository).getWebsite(webpageUuid);
    }

    @Override
    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) throws IdentifiableServiceException {
        try {
            return ((WebpageRepository)this.repository).saveWithParentWebsite(webpage, parentWebsiteUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save top-level webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUuid) throws IdentifiableServiceException {
        try {
            return ((WebpageRepository)this.repository).saveWithParentWebpage(webpage, parentWebpageUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }
}

