/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.SubtopicRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.SubtopicRepositoryEndpoint;
import de.digitalcollections.model.api.http.exceptions.client.ResourceNotFoundException;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.entity.parts.SubtopicImpl;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SubtopicRepositoryImpl
extends EntityPartRepositoryImpl<Subtopic, Entity>
implements SubtopicRepository {
    @Autowired
    private SubtopicRepositoryEndpoint endpoint;

    @Override
    public long count() {
        return this.endpoint.count();
    }

    @Override
    public Subtopic create() {
        return new SubtopicImpl();
    }

    @Override
    public PageResponse<Subtopic> find(PageRequest pageRequest) {
        IdentifiableRepositoryImpl.FindParams f = this.getFindParams(pageRequest);
        PageResponse<Subtopic> pageResponse = this.endpoint.find(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return this.getGenericPageResponse(pageResponse);
    }

    @Override
    public Subtopic findOneByIdentifier(String namespace, String id) {
        try {
            return this.endpoint.findOneByIdentifier(namespace, id);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    @Override
    public Subtopic findOne(UUID uuid) {
        return this.endpoint.findOne(uuid);
    }

    @Override
    public Subtopic findOne(UUID uuid, Locale locale) {
        return this.endpoint.findOne(uuid, locale.toString());
    }

    public List<Entity> getEntities(Subtopic subtopic) {
        return this.getEntities(subtopic.getUuid());
    }

    public List<Entity> getEntities(UUID subtopicUuid) {
        List<Entity> entities = this.endpoint.getEntities(subtopicUuid);
        return entities.stream().map(e -> e).collect(Collectors.toList());
    }

    public List<FileResource> getFileResources(Subtopic subtopic) {
        return this.getFileResources(subtopic.getUuid());
    }

    public List<FileResource> getFileResources(UUID subtopicUuid) {
        return this.endpoint.getFileResources(subtopicUuid);
    }

    public Subtopic getParent(UUID nodeUuid) {
        return this.endpoint.getParent(nodeUuid);
    }

    public List<Subtopic> getSubtopicsOfEntity(Entity entity) {
        return this.getSubtopicsOfEntity(entity.getUuid());
    }

    public List<Subtopic> getSubtopicsOfEntity(UUID entityUuid) {
        List<Subtopic> subtopics = this.endpoint.getSubtopicsOfEntity(entityUuid);
        return subtopics.stream().map(s -> s).collect(Collectors.toList());
    }

    public List<Subtopic> getSubtopicsOfFileResource(FileResource fileResource) {
        return this.getSubtopicsOfFileResource(fileResource.getUuid());
    }

    public List<Subtopic> getSubtopicsOfFileResource(UUID fileResourceUuid) {
        List<Subtopic> subtopics = this.endpoint.getSubtopicsOfFileResource(fileResourceUuid);
        return subtopics.stream().map(s -> s).collect(Collectors.toList());
    }

    @Override
    public Subtopic save(Subtopic subtopic) {
        return this.endpoint.save(subtopic);
    }

    public List<Entity> saveEntities(Subtopic subtopic, List<Entity> entities) {
        return this.saveEntities(subtopic.getUuid(), entities);
    }

    public List<Entity> saveEntities(UUID subtopicUuid, List<Entity> entities) {
        List<Entity> savedEntities = this.endpoint.saveEntities(subtopicUuid, entities.stream().map(Entity.class::cast).collect(Collectors.toList()));
        return savedEntities.stream().map(e -> e).collect(Collectors.toList());
    }

    public List<FileResource> saveFileResources(Subtopic subtopic, List<FileResource> fileResources) {
        return this.saveFileResources(subtopic.getUuid(), fileResources);
    }

    public List<FileResource> saveFileResources(UUID subtopicUuid, List<FileResource> fileResources) {
        return this.endpoint.saveFileResources(subtopicUuid, fileResources);
    }

    @Override
    public Subtopic update(Subtopic subtopic) {
        return this.endpoint.update(subtopic.getUuid(), subtopic);
    }

    public List<Subtopic> getChildren(UUID uuid) {
        return this.endpoint.getChildren(uuid);
    }

    public List<Subtopic> getChildren(Subtopic subtopic) {
        return this.getChildren(subtopic.getUuid());
    }

    public Subtopic saveWithParentTopic(Subtopic subtopic, UUID parentTopicUUID) {
        return this.endpoint.saveWithParentTopic(subtopic, parentTopicUUID);
    }

    public Subtopic saveWithParentSubtopic(Subtopic subtopic, UUID parentSubtopicUUID) {
        return this.endpoint.saveWithParentSubtopic(subtopic, parentSubtopicUUID);
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID subtopicUuid) {
        return this.endpoint.getBreadcrumbNavigation(subtopicUuid);
    }

    public Topic getTopic(UUID subtopicUuid) {
        return this.endpoint.getTopic(subtopicUuid);
    }
}

