/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.impl.repository.RepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.util.List;
import java.util.UUID;

public interface SubtopicRepositoryEndpoint
extends RepositoryEndpoint {
    @RequestLine(value="GET /latest/subtopics/count")
    public long count();

    @RequestLine(value="GET /latest/subtopics?pageNumber={pageNumber}&pageSize={pageSize}&sortField={sortField}&sortDirection={sortDirection}&nullHandling={nullHandling}")
    public PageResponse<Subtopic> find(@Param(value="pageNumber") int var1, @Param(value="pageSize") int var2, @Param(value="sortField") String var3, @Param(value="sortDirection") String var4, @Param(value="nullHandling") String var5);

    @RequestLine(value="GET /latest/subtopics/{uuid}")
    public Subtopic findOne(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/subtopics/{uuid}?locale={locale}")
    public Subtopic findOne(@Param(value="uuid") UUID var1, @Param(value="locale") String var2);

    @RequestLine(value="GET /latest/subtopics/identifier/{namespace}:{id}.json")
    @Headers(value={"Accept: application/json"})
    public Subtopic findOneByIdentifier(@Param(value="namespace") String var1, @Param(value="id") String var2);

    @RequestLine(value="GET /latest/subtopics/{uuid}/children")
    public List<Subtopic> getChildren(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/subtopics/{uuid}/entities")
    public List<Entity> getEntities(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/subtopics/{uuid}/fileresources")
    public List<FileResource> getFileResources(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/subtopics/{uuid}/parent")
    public Subtopic getParent(@Param(value="uuid") UUID var1);

    @RequestLine(value="POST /latest/subtopics")
    @Headers(value={"Content-Type: application/json"})
    public Subtopic save(Subtopic var1);

    @RequestLine(value="POST /latest/subtopics/{uuid}/entities")
    @Headers(value={"Content-Type: application/json"})
    public List<Entity> saveEntities(@Param(value="uuid") UUID var1, List<Entity> var2);

    @RequestLine(value="POST /latest/subtopics/{uuid}/fileresources")
    @Headers(value={"Content-Type: application/json"})
    public List<FileResource> saveFileResources(@Param(value="uuid") UUID var1, List<FileResource> var2);

    @RequestLine(value="POST /latest/topics/{parentTopicUuid}/subtopic")
    @Headers(value={"Content-Type: application/json"})
    public Subtopic saveWithParentTopic(Subtopic var1, @Param(value="parentTopicUuid") UUID var2);

    @RequestLine(value="POST /latest/subtopics/{parentSubtopicUuid}/subtopic")
    @Headers(value={"Content-Type: application/json"})
    public Subtopic saveWithParentSubtopic(Subtopic var1, @Param(value="parentSubtopicUuid") UUID var2);

    @RequestLine(value="PUT /latest/subtopics/{uuid}")
    @Headers(value={"Content-Type: application/json"})
    public Subtopic update(@Param(value="uuid") UUID var1, Subtopic var2);

    @RequestLine(value="GET /latest/subtopics/entity/{uuid}")
    public List<Subtopic> getSubtopicsOfEntity(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/subtopics/fileresource/{uuid}")
    public List<Subtopic> getSubtopicsOfFileResource(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/subtopics/{uuid}/breadcrumb")
    public BreadcrumbNavigation getBreadcrumbNavigation(@Param(value="uuid") UUID var1);

    @RequestLine(value="GET /latest/subtopics/{uuid}/topic")
    public Topic getTopic(@Param(value="uuid") UUID var1);
}

