/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.EntityPartRepository;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.admin.backend.impl.repository.identifiable.entity.parts.EntityPartRepositoryEndpoint;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.EntityPart;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntityPartRepositoryImpl<P extends EntityPart, E extends Entity>
extends IdentifiableRepositoryImpl<P>
implements EntityPartRepository<P, E> {
    @Autowired
    private EntityPartRepositoryEndpoint endpoint;

    public void addRelatedEntity(EntityPart entityPart, Entity entity) {
        this.addRelatedEntity(entityPart.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID entityPartUuid, UUID entityUuid) {
        this.endpoint.addRelatedEntity(entityPartUuid, entityUuid);
    }

    public void addRelatedFileresource(EntityPart entityPart, FileResource fileResource) {
        this.addRelatedFileresource(entityPart.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID entityPartUuid, UUID fileResourceUuid) {
        this.endpoint.addRelatedFileresource(entityPartUuid, fileResourceUuid);
    }

    public List<E> getRelatedEntities(P entityPart) {
        return this.getRelatedEntities(entityPart.getUuid());
    }

    public List<E> getRelatedEntities(UUID entityPartUuid) {
        List<Entity> relatedEntities = this.endpoint.getRelatedEntities(entityPartUuid);
        return relatedEntities.stream().map(e -> e).collect(Collectors.toList());
    }

    public List<FileResource> getRelatedFileResources(P entityPart) {
        return this.getRelatedFileResources(entityPart.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID entityPartUuid) {
        return this.endpoint.getRelatedFileResources(entityPartUuid);
    }

    public List<E> saveRelatedEntities(P entityPart, List<E> entities) {
        return this.saveRelatedEntities(entityPart.getUuid(), entities);
    }

    public List<E> saveRelatedEntities(UUID entityPartUuid, List<E> entities) {
        List<Entity> relatedEntities = this.endpoint.saveRelatedEntities(entityPartUuid, entities.stream().map(Entity.class::cast).collect(Collectors.toList()));
        return relatedEntities.stream().map(e -> e).collect(Collectors.toList());
    }

    public List<FileResource> saveRelatedFileResources(P entityPart, List<FileResource> fileResources) {
        return this.saveRelatedFileResources(entityPart.getUuid(), fileResources);
    }

    public List<FileResource> saveRelatedFileResources(UUID entityPartUuid, List<FileResource> fileResources) {
        return this.endpoint.saveRelatedFileResources(entityPartUuid, fileResources);
    }
}

