/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.frontend.website.controller.advice;

import de.digitalcollections.cudami.frontend.website.config.TemplateConfig;
import de.digitalcollections.cudami.frontend.website.service.ContentService;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

@ControllerAdvice
@SessionAttributes(value={"maxLevel"})
public class GlobalControllerAdvice {
    private final ContentService contentService;
    private final TemplateConfig templateConfig;

    public GlobalControllerAdvice(TemplateConfig templateConfig, ContentService contentService) {
        this.templateConfig = templateConfig;
        this.contentService = contentService;
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void handleNotFound() {
    }

    @ModelAttribute(value="contentWebpages")
    public List<Webpage> getContentWebpages() {
        return this.contentService.getContentPages();
    }

    @ModelAttribute(value="footerWebpages")
    public List<Webpage> getFooterWebpages() {
        return this.contentService.getFooterPages();
    }

    @ModelAttribute(value="navMaxLevel")
    public int getTemplateNavMaxLevel() {
        return this.templateConfig.getNavMaxLevel();
    }

    @ModelAttribute(value="website")
    public Website getWebsite() {
        return this.contentService.getWebsite();
    }
}

