/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.frontend.website.controller;

import de.digitalcollections.cudami.frontend.website.config.TemplateConfig;
import de.digitalcollections.cudami.frontend.website.service.ContentService;
import de.digitalcollections.model.identifiable.web.Webpage;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.server.ResponseStatusException;

@Controller
public class MainController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainController.class);
    private final ContentService contentService;
    private final TemplateConfig templateConfig;

    public MainController(TemplateConfig templateConfig, ContentService contentService) {
        this.templateConfig = templateConfig;
        this.contentService = contentService;
    }

    @GetMapping(value={"", "/"})
    public String home(Model model) {
        LOGGER.debug("Homepage requested");
        Webpage startPage = this.contentService.getStartPage();
        model.addAttribute("startPage", (Object)startPage);
        return this.templateConfig.getName() + "/index";
    }

    @GetMapping(value={"/p/{uuid}"})
    public String viewWebpage(@PathVariable UUID uuid, Model model, HttpServletResponse resp) {
        LOGGER.debug("Webpage {} requested", (Object)uuid);
        Pair tuple = this.contentService.getWebpage(uuid);
        Webpage webpage = (Webpage)tuple.getLeft();
        if (webpage == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        Locale locale = (Locale)tuple.getRight();
        model.addAttribute("locale", (Object)locale);
        model.addAttribute("webpage", (Object)webpage);
        return this.templateConfig.getName() + "/webpage";
    }
}

