/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.model.impl.paging;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.Sorting;
import de.digitalcollections.core.model.api.paging.enums.Direction;
import de.digitalcollections.core.model.impl.paging.SortingImpl;
import java.io.Serializable;

public class PageRequestImpl
implements PageRequest,
Serializable {
    private int page;
    private int size;
    private Sorting sort;

    public PageRequestImpl() {
    }

    public void setPageNumber(int page) {
        this.page = page;
    }

    public void setPageSize(int size) {
        this.size = size;
    }

    public void setSorting(Sorting sort) {
        this.sort = sort;
    }

    public PageRequestImpl(int page, int size) {
        this(page, size, null);
    }

    public PageRequestImpl(int page, int size, Direction direction, String ... properties) {
        this(page, size, new SortingImpl(direction, properties));
    }

    public PageRequestImpl(int page, int size, Sorting sort) {
        if (page < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (size < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequestImpl)) {
            return false;
        }
        PageRequestImpl that = (PageRequestImpl)obj;
        boolean sortEqual = this.sort == null ? that.sort == null : this.sort.equals(that.sort);
        boolean othersEqual = this.page == that.page && this.size == that.size;
        return othersEqual && sortEqual;
    }

    @Override
    public PageRequest first() {
        return new PageRequestImpl(0, this.getPageSize(), this.getSorting());
    }

    @Override
    public int getOffset() {
        return this.page * this.size;
    }

    @Override
    public int getPageNumber() {
        return this.page;
    }

    @Override
    public int getPageSize() {
        return this.size;
    }

    @Override
    public Sorting getSorting() {
        return this.sort;
    }

    @Override
    public boolean hasPrevious() {
        return this.page > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.page;
        result = 31 * result + this.size;
        return 31 * result + (null == this.sort ? 0 : this.sort.hashCode());
    }

    @Override
    public PageRequest next() {
        return new PageRequestImpl(this.getPageNumber() + 1, this.getPageSize(), this.getSorting());
    }

    public PageRequest previous() {
        return this.getPageNumber() == 0 ? this : new PageRequestImpl(this.getPageNumber() - 1, this.getPageSize(), this.getSorting());
    }

    @Override
    public PageRequest previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public String toString() {
        return String.format("Page request [number: %d, size %d, sort: %s]", this.getPageNumber(), this.getPageSize(), this.sort == null ? null : this.sort.toString());
    }
}

