/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.model.api;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class MimeType {
    private static Map<String, MimeType> knownTypes;
    private static Map<String, String> extensionMapping;
    private static final Pattern MIME_PATTERN;
    public static final MimeType MIME_WILDCARD;
    public static final MimeType MIME_IMAGE;
    public static final MimeType MIME_APPLICATION_JSON;
    public static final MimeType MIME_APPLICATION_XML;
    public static final MimeType MIME_IMAGE_JPEG;
    public static final MimeType MIME_IMAGE_TIF;
    public static final MimeType MIME_IMAGE_PNG;
    private final String primaryType;
    private final String subType;
    private final String suffix;
    private List<String> extensions;

    public static MimeType fromExtension(String ext) {
        String extension = ext.startsWith(".") ? ext.substring(1).toLowerCase() : ext.toLowerCase();
        String typeName = extensionMapping.get(extension);
        if (typeName != null) {
            return knownTypes.get(typeName);
        }
        return null;
    }

    public static MimeType fromFilename(String filename) {
        return MimeType.fromExtension(FilenameUtils.getExtension((String)filename));
    }

    public static MimeType fromURI(URI uri) {
        try {
            return MimeType.fromFilename(Paths.get(uri).toString());
        }
        catch (FileSystemNotFoundException e) {
            return MimeType.fromExtension(FilenameUtils.getExtension((String)uri.toString()));
        }
    }

    public static MimeType fromTypename(String typeName) {
        MimeType knownType = knownTypes.get(typeName);
        if (knownType != null) {
            return knownType;
        }
        MimeType unknownType = new MimeType(typeName);
        if (!(unknownType.getPrimaryType().startsWith("x-") && unknownType.getSubType().startsWith("vnd.") && unknownType.getSubType().startsWith("prs."))) {
            return null;
        }
        return unknownType;
    }

    private MimeType(String typeName) {
        this(typeName, Collections.emptyList());
    }

    private MimeType(String typeName, List<String> extensions) {
        if (typeName.equals("*")) {
            this.primaryType = "*";
            this.subType = "*";
            this.suffix = "";
        } else {
            Matcher matcher = MIME_PATTERN.matcher(typeName);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("%s is not a valid MIME type!", typeName));
            }
            this.primaryType = matcher.group("primaryType");
            this.subType = matcher.group("subType");
            this.suffix = matcher.group("suffix");
            this.extensions = extensions;
        }
    }

    public String getTypeName() {
        StringBuilder sb = new StringBuilder(this.primaryType).append("/").append(this.subType);
        if (this.suffix != null) {
            sb.append("+").append(this.suffix);
        }
        return sb.toString();
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    private void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean matches(Object other) {
        if (other instanceof MimeType) {
            MimeType mime = (MimeType)other;
            if (mime == MIME_WILDCARD || this == MIME_WILDCARD) {
                return true;
            }
            if ((mime.getSubType().equals("*") || this.getSubType().equals("*")) && this.getPrimaryType().equals(mime.getPrimaryType())) {
                return true;
            }
            return super.equals(other);
        }
        return false;
    }

    static {
        MIME_PATTERN = Pattern.compile("^(?<primaryType>[-a-z]+?)/(?<subType>[-\\\\.a-z0-9*]+?)(?:\\+(?<suffix>\\w+))?$");
        InputStream mimeStream = MimeType.class.getClassLoader().getResourceAsStream("mime.types");
        BufferedReader mimeReader = new BufferedReader(new InputStreamReader(mimeStream));
        List typeStrings = mimeReader.lines().map(l -> l.replaceAll("^# ", "")).filter(l -> MIME_PATTERN.matcher((CharSequence)Splitter.on((char)'\t').trimResults().omitEmptyStrings().split((CharSequence)l).iterator().next()).matches()).collect(Collectors.toList());
        knownTypes = typeStrings.stream().filter(l -> l.contains("\t")).map(l -> l.replaceAll("\\t+", "\t").split("\\t")).map(p -> new MimeType(p[0], Arrays.asList(p[1].split(" ")))).collect(Collectors.toMap(MimeType::getTypeName, Function.identity()));
        typeStrings.stream().filter(l -> !l.contains("\t")).map(t -> new MimeType((String)t, Collections.emptyList())).forEach(m -> knownTypes.put(m.getTypeName(), (MimeType)m));
        knownTypes.get("image/jpeg").setExtensions(Arrays.asList("jpg", "jpeg", "jpe"));
        knownTypes.get("image/tiff").setExtensions(Arrays.asList("tif", "tiff"));
        ArrayList<String> xmlExtensions = new ArrayList<String>(knownTypes.get("application/xml").getExtensions());
        xmlExtensions.add("ent");
        knownTypes.get("application/xml").setExtensions(xmlExtensions);
        extensionMapping = new HashMap<String, String>();
        for (Map.Entry<String, MimeType> entry : knownTypes.entrySet()) {
            String typeName = entry.getKey();
            for (String ext : entry.getValue().getExtensions()) {
                extensionMapping.put(ext, typeName);
            }
        }
        MIME_WILDCARD = new MimeType("*", Collections.emptyList());
        MIME_IMAGE = new MimeType("image/*", Collections.emptyList());
        MIME_APPLICATION_JSON = knownTypes.get("application/json");
        MIME_APPLICATION_XML = knownTypes.get("application/xml");
        MIME_IMAGE_JPEG = knownTypes.get("image/jpeg");
        MIME_IMAGE_TIF = knownTypes.get("image/tiff");
        MIME_IMAGE_PNG = knownTypes.get("image/png");
    }
}

