/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.xml.xpath;

import de.digitalcollections.commons.xml.xpath.XPathExpressionCache;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(XPathWrapper.class);
    private Document document;
    private XPathExpressionCache expressionCache;

    private XPathWrapper() {
    }

    public XPathWrapper(Document document, XPathExpressionCache expressionCache) {
        this.document = document;
        this.expressionCache = expressionCache;
    }

    public XPathWrapper(Document document) {
        this(document, new XPathExpressionCache());
    }

    public void setDefaultNamespace(String namespaceUrl) {
        this.expressionCache.setDefaultNamespace(namespaceUrl);
    }

    public Node asNode(String xpath) {
        return this.asNode(xpath, 0);
    }

    public Node asNode(String xpath, int index) {
        NodeList nodeList = (NodeList)this.evaluateXpath(this.getDocument(), xpath, XPathConstants.NODESET);
        return nodeList.item(index);
    }

    public Node asNode(Node node, String xpath) {
        return (Node)this.evaluateXpath(node, xpath, XPathConstants.NODE);
    }

    public NodeList asNodeList(String xpath) {
        return (NodeList)this.evaluateXpath(this.getDocument(), xpath, XPathConstants.NODESET);
    }

    public NodeList asNodeList(Node node, String xpath) {
        return (NodeList)this.evaluateXpath(node, xpath, XPathConstants.NODESET);
    }

    public List<Node> asListOfNodes(String xpath) {
        NodeList nodeList = this.asNodeList(xpath);
        ArrayList<Node> list = new ArrayList<Node>(nodeList.getLength());
        int l = nodeList.getLength();
        for (int i = 0; i < l; ++i) {
            list.add(nodeList.item(i));
        }
        return list;
    }

    public List<Node> asListOfNodes(Node node, String xpath) {
        NodeList nodeList = this.asNodeList(node, xpath);
        ArrayList<Node> list = new ArrayList<Node>(nodeList.getLength());
        int l = nodeList.getLength();
        for (int i = 0; i < l; ++i) {
            list.add(nodeList.item(i));
        }
        return list;
    }

    public List<String> asListOfStrings(String xpath) {
        NodeList nodeList = this.asNodeList(xpath);
        List<String> list = this.nodeListContentsToListOfStrings(nodeList);
        return list;
    }

    public List<String> asListOfStrings(Node node, String xpath) {
        NodeList nodeList = this.asNodeList(node, xpath);
        List<String> list = this.nodeListContentsToListOfStrings(nodeList);
        return list;
    }

    private List<String> nodeListContentsToListOfStrings(NodeList nodeList) throws DOMException {
        ArrayList<String> list = new ArrayList<String>(nodeList.getLength());
        int l = nodeList.getLength();
        for (int i = 0; i < l; ++i) {
            String textContent = nodeList.item(i).getTextContent();
            if (textContent == null) {
                textContent = "";
            }
            textContent = textContent.trim();
            list.add(textContent);
        }
        return list;
    }

    public String asString(String xpath) {
        String rawString = (String)this.evaluateXpath(this.getDocument(), xpath, XPathConstants.STRING);
        if (rawString == null) {
            return "";
        }
        return rawString.trim();
    }

    public String asString(Node node, String xpath) {
        String rawString = (String)this.evaluateXpath(node, xpath, XPathConstants.STRING);
        if (rawString == null) {
            return "";
        }
        return rawString.trim();
    }

    private Object evaluateXpath(Node node, String xpath, QName returnType) {
        XPathExpression expr = this.getXpathExpression(xpath);
        try {
            return expr.evaluate(node, returnType);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Boolean asBoolean(String xpath) {
        String value = (String)this.evaluateXpath(this.getDocument(), xpath, XPathConstants.STRING);
        return Boolean.parseBoolean(value);
    }

    public Number asNumber(String xpath) {
        return (Number)this.evaluateXpath(this.getDocument(), xpath, XPathConstants.NUMBER);
    }

    public Node getRelativeNode(Node node, String relativeXpath) {
        if (!relativeXpath.startsWith(".")) {
            throw new IllegalArgumentException(String.format("Relative node '%s' below '%s' must start with a period! ", relativeXpath, this.getFullXPath(node)));
        }
        List<Node> nodes = this.asListOfNodes(node, relativeXpath);
        if (nodes == null || nodes.isEmpty()) {
            LOGGER.info("No relative node found for {} and relative path={}", (Object)this.getFullXPath(node), (Object)relativeXpath);
            return null;
        }
        return nodes.get(0);
    }

    public String serializeToString() throws UnsupportedEncodingException, TransformerException {
        DOMSource source = new DOMSource(this.getDocument());
        StreamResult result = new StreamResult(new StringWriter());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public Document getDocument() {
        return this.document;
    }

    private XPathExpression getXpathExpression(String xpath) {
        return this.expressionCache.get(xpath);
    }

    public String getFullXPath(Node n) {
        if (null == n) {
            return null;
        }
        Node parent = null;
        Stack<Node> hierarchy = new Stack<Node>();
        StringBuilder buffer = new StringBuilder();
        hierarchy.push(n);
        switch (n.getNodeType()) {
            case 2: {
                parent = ((Attr)n).getOwnerElement();
                break;
            }
            case 1: {
                parent = n.getParentNode();
                break;
            }
            case 9: {
                parent = n.getParentNode();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Node type" + n.getNodeType());
            }
        }
        while (null != parent && parent.getNodeType() != 9) {
            hierarchy.push(parent);
            parent = parent.getParentNode();
        }
        Object obj = null;
        while (!hierarchy.isEmpty()) {
            Object e = hierarchy.pop();
            obj = e;
            if (null == e) break;
            Node node = obj;
            boolean handled = false;
            if (node.getNodeType() == 1) {
                Element e2 = (Element)node;
                if (buffer.length() == 0) {
                    buffer.append(node.getNodeName());
                    continue;
                }
                buffer.append("/");
                buffer.append(node.getNodeName());
                if (node.hasAttributes()) {
                    if (e2.hasAttribute("id")) {
                        buffer.append("[@id='").append(e2.getAttribute("id")).append("']");
                        handled = true;
                    } else if (e2.hasAttribute("name")) {
                        buffer.append("[@name='").append(e2.getAttribute("name")).append("']");
                        handled = true;
                    }
                }
                if (handled) continue;
                int prev_siblings = 1;
                for (Node prev_sibling = node.getPreviousSibling(); null != prev_sibling; prev_sibling = prev_sibling.getPreviousSibling()) {
                    if (prev_sibling.getNodeType() != node.getNodeType() || !prev_sibling.getNodeName().equalsIgnoreCase(node.getNodeName())) continue;
                    ++prev_siblings;
                }
                buffer.append("[").append(prev_siblings).append("]");
                continue;
            }
            if (node.getNodeType() != 2) continue;
            buffer.append("/@");
            buffer.append(node.getNodeName());
        }
        return buffer.toString();
    }
}

