/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.xml.xpath;

import de.digitalcollections.commons.xml.xpath.XPathBinding;
import de.digitalcollections.commons.xml.xpath.XPathMappingException;
import de.digitalcollections.commons.xml.xpath.XPathVariable;
import de.digitalcollections.commons.xml.xpath.XPathWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathMapper
implements InvocationHandler {
    private static final Pattern variablePattern = Pattern.compile("\\{([a-zA-Z0-9_-]+?)\\}");
    private final XPathWrapper xpw;

    public static <T> T makeProxy(Document doc, Class<? extends T> iface, Class<?> ... otherIfaces) {
        Class[] allInterfaces = (Class[])Stream.concat(Stream.of(iface), Stream.of(otherIfaces)).distinct().toArray(Class[]::new);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), allInterfaces, (InvocationHandler)new XPathMapper(doc));
    }

    private XPathMapper(Document doc) {
        this.xpw = new XPathWrapper(doc);
    }

    public Set<String> getVariables(String templateString) {
        Matcher matcher = variablePattern.matcher(templateString);
        HashSet<String> variables = new HashSet<String>();
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        XPathBinding binding = method.getAnnotation(XPathBinding.class);
        if (binding == null) {
            throw new XPathMappingException("No @XPathBinding annotation was found on the specified method!");
        }
        Set<String> variables = this.getVariables(binding.valueTemplate());
        if (binding.multiLanguage()) {
            if (!method.getReturnType().isAssignableFrom(Map.class)) {
                throw new XPathMappingException("Method return type must be a Map<Locale, String> type if multiLanguage=true.");
            }
        } else if (!method.getReturnType().isAssignableFrom(String.class)) {
            throw new XPathMappingException("Return type must be String if multiLanguage=false;");
        }
        if (!binding.defaultNamespace().isEmpty()) {
            this.xpw.setDefaultNamespace(binding.defaultNamespace());
        }
        LinkedHashMap<String, Map<Locale, String>> resolvedVariables = new LinkedHashMap<String, Map<Locale, String>>();
        for (String variableName : variables) {
            XPathVariable var = Arrays.stream(binding.variables()).filter(v -> v.name().equals(variableName)).findFirst().orElseThrow(() -> new XPathMappingException(String.format("Could not resolve variable `%s`", variableName)));
            resolvedVariables.put(variableName, this.resolveVariable(var));
        }
        Map<Locale, String> resolved = this.executeTemplate(binding.valueTemplate(), resolvedVariables);
        if (binding.multiLanguage()) {
            return resolved;
        }
        if (!resolved.isEmpty()) {
            return resolved.entrySet().iterator().next().getValue();
        }
        return null;
    }

    private Map<Locale, String> executeTemplate(String templateString, Map<String, Map<Locale, String>> resolvedVariables) throws XPathExpressionException {
        Set langs = resolvedVariables.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashMap<Locale, String> out = new LinkedHashMap<Locale, String>();
        for (Locale lang : langs) {
            String stringRepresentation = templateString;
            String context = this.extractContext(stringRepresentation);
            while (context != null) {
                stringRepresentation = stringRepresentation.replace("<" + context + ">", this.resolveVariableContext(lang, context, resolvedVariables));
                context = this.extractContext(stringRepresentation);
            }
            Matcher matcher = variablePattern.matcher(stringRepresentation);
            while (matcher.find()) {
                String varName = matcher.group(1);
                if (resolvedVariables.get(varName).isEmpty()) {
                    return null;
                }
                Locale langToResolve = resolvedVariables.get(varName).containsKey(lang) ? lang : resolvedVariables.get(varName).entrySet().iterator().next().getKey();
                stringRepresentation = stringRepresentation.replace(matcher.group(), resolvedVariables.get(varName).get(langToResolve));
                matcher = variablePattern.matcher(stringRepresentation);
            }
            out.put(lang, stringRepresentation.replace("\\<", "<").replace("\\>", ">"));
        }
        return out;
    }

    private String extractContext(String template) throws XPathExpressionException {
        StringBuilder ctx = new StringBuilder();
        boolean isEscaped = false;
        boolean wasOpened = false;
        int numOpen = 0;
        for (char c : template.toCharArray()) {
            if (c == '\\') {
                isEscaped = true;
                if (numOpen <= 0) continue;
                ctx.append(c);
                continue;
            }
            if (c == '<') {
                if (numOpen > 0) {
                    ctx.append(c);
                }
                if (!isEscaped) {
                    ++numOpen;
                    if (wasOpened) continue;
                    wasOpened = true;
                    continue;
                }
                isEscaped = false;
                continue;
            }
            if (c == '>') {
                if (numOpen > 0 && isEscaped || numOpen > 1) {
                    ctx.append(c);
                }
                if (!isEscaped) {
                    if (--numOpen != 0) continue;
                    return ctx.toString();
                }
                isEscaped = false;
                continue;
            }
            if (!wasOpened) continue;
            ctx.append(c);
        }
        if (wasOpened) {
            throw new XPathExpressionException(String.format("Mismatched context delimiters, %s were unclosed at the end of parsing.", numOpen));
        }
        return null;
    }

    private String resolveVariableContext(Locale language, String variableContext, Map<String, Map<Locale, String>> resolvedVariables) {
        Matcher varMatcher = variablePattern.matcher(variableContext);
        varMatcher.find();
        String variableName = varMatcher.group(1);
        Map<Locale, String> resolvedValues = resolvedVariables.get(variableName);
        if (resolvedValues == null || resolvedValues.isEmpty()) {
            return "";
        }
        if (resolvedValues.containsKey(language)) {
            return variableContext.replace(varMatcher.group(), resolvedValues.get(language));
        }
        return variableContext.replace(varMatcher.group(), resolvedValues.entrySet().iterator().next().getValue());
    }

    private Map<Locale, String> resolveVariable(XPathVariable var) throws XPathExpressionException {
        LinkedHashMap<Locale, String> result = new LinkedHashMap<Locale, String>();
        for (String path : var.paths()) {
            List<Node> nodes = this.xpw.asListOfNodes(path);
            for (Node node : nodes) {
                Node langCode;
                Locale locale = null;
                if (node.hasAttributes() && (langCode = node.getAttributes().getNamedItem("xml:lang")) != null) {
                    locale = Locale.forLanguageTag(langCode.getNodeValue());
                }
                if (locale == null || locale.getLanguage().isEmpty()) {
                    locale = Locale.forLanguageTag("");
                }
                String value = node.getTextContent().replace("<", "\\<").replace(">", "\\>");
                result.put(locale, value);
            }
            if (!result.isEmpty()) break;
        }
        return result;
    }
}

