/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.xml.xpath;

import de.digitalcollections.commons.xml.namespaces.DigitalCollectionsNamespaceContext;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class XPathExpressionCache {
    private final ConcurrentHashMap<String, XPathExpression> cache = new ConcurrentHashMap();
    private final XPath xpath = XPathFactory.newInstance().newXPath();

    public XPathExpressionCache() {
        this.xpath.setNamespaceContext(new DigitalCollectionsNamespaceContext());
    }

    public XPathExpression get(String expression) {
        return this.cache.computeIfAbsent(expression, x -> {
            XPathExpression result = null;
            try {
                result = this.xpath.compile((String)x);
            }
            catch (XPathExpressionException exception) {
                throw new IllegalArgumentException(exception);
            }
            return result;
        });
    }

    public int getSize() {
        return this.cache.size();
    }

    public List<String> getExpressions() {
        return Collections.list(this.cache.keys());
    }

    public void setDefaultNamespace(String namespaceUri) {
        if (!this.xpath.getNamespaceContext().getNamespaceURI("").equals(namespaceUri)) {
            this.cache.clear();
            this.xpath.setNamespaceContext(new DigitalCollectionsNamespaceContext(namespaceUri));
        }
    }
}

