/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springmvc.security.jwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.commons.springmvc.security.jwt.TokenAuthenticationService;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class JWTLoginFilter
extends AbstractAuthenticationProcessingFilter {
    private TokenAuthenticationService tokenAuthenticationService;

    public JWTLoginFilter(String route, AuthenticationManager authenticationManager, TokenAuthenticationService service) {
        super((RequestMatcher)new AntPathRequestMatcher(route));
        this.setAuthenticationManager(authenticationManager);
        this.tokenAuthenticationService = service;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree((InputStream)request.getInputStream());
        String username = root.get("username").asText();
        String password = root.get("password").asText();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        return this.getAuthenticationManager().authenticate((Authentication)token);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        String name = authResult.getName();
        this.tokenAuthenticationService.addAuthentication(response, name);
    }
}

