/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springmvc.controller;

import de.digitalcollections.commons.springmvc.exceptions.ResourceNotFoundException;
import java.sql.Timestamp;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class GlobalExceptionController
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionController.class);
    private String activeProfile;

    public void setEnvironment(Environment environment) {
        String[] activeProfiles = environment.getActiveProfiles();
        if (activeProfiles.length == 1) {
            this.activeProfile = activeProfiles[0];
        }
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ModelAndView handleResourceNotFoundException(Exception ex) {
        ModelAndView model = new ModelAndView("error");
        model.addObject("timestamp", (Object)new Timestamp(new Date().getTime()));
        model.addObject("errorCode", (Object)"404");
        return model;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ModelAndView handleAllException(Exception ex) {
        LOGGER.error("Internal Error", (Throwable)ex);
        ModelAndView model = new ModelAndView("error");
        model.addObject("timestamp", (Object)new Timestamp(new Date().getTime()));
        model.addObject("errorCode", (Object)"500");
        if (!"PROD".equals(this.activeProfile)) {
            model.addObject("exception", (Object)ex);
        }
        return model;
    }
}

