/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springaop;

import java.lang.reflect.Proxy;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public abstract class AbstractAopMethodLogger {
    private static Logger logger = LoggerFactory.getLogger(AbstractAopMethodLogger.class);

    public abstract void methodsToBeLogged();

    @Before(value="methodsToBeLogged()")
    public void logMethodCall(JoinPoint joinPoint) {
        Object target = joinPoint.getTarget();
        Class targetClass = target.getClass();
        if (target instanceof Proxy) {
            targetClass = AopUtils.getTargetClass((Object)target);
        }
        String targetClassName = targetClass.getName();
        String logMsg = this.createMsgForLogMethodCall(joinPoint);
        Logger targetLog = LoggerFactory.getLogger((String)targetClassName);
        targetLog.info(logMsg);
    }

    String createMsgForLogMethodCall(JoinPoint joinPoint) {
        StringBuilder buffer = new StringBuilder();
        String targetMethodName = joinPoint.getSignature().getName();
        buffer.append(targetMethodName);
        buffer.append("(");
        Object[] args = joinPoint.getArgs();
        CodeSignature codeSignature = (CodeSignature)joinPoint.getSignature();
        String[] argNames = codeSignature.getParameterNames();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            String argName = null;
            if (argNames != null && (argName = argNames[i]) != null) {
                buffer.append(argNames[i]);
                buffer.append("=");
            }
            buffer.append(arg.getClass().getSimpleName());
            buffer.append(" ");
            String argValue = arg.toString();
            if (argName != null && (argName.contains("password") || argName.contains("pwd"))) {
                argValue = "***";
            }
            if (argValue.length() > 50) {
                argValue = argValue.substring(0, 49) + "...";
            }
            buffer.append(argValue);
            if (i >= args.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="methodsToBeLogged()")
    public Object logMethodDuration(ProceedingJoinPoint call) throws Throwable {
        Object returnValue;
        if (logger.isDebugEnabled()) {
            String targetClassName = call.getTarget().getClass().getName();
            String targetMethodName = call.getSignature().getName();
            Logger targetLog = LoggerFactory.getLogger((String)targetClassName);
            if (targetLog.isDebugEnabled()) {
                StopWatch clock = new StopWatch(this.getClass().getName());
                try {
                    clock.start(call.toShortString());
                    returnValue = call.proceed();
                }
                finally {
                    clock.stop();
                    String msg = this.createMsgForLogMethodDuration(targetMethodName, clock.getTotalTimeMillis());
                    targetLog.debug(msg);
                }
            } else {
                returnValue = call.proceed();
            }
        } else {
            returnValue = call.proceed();
        }
        return returnValue;
    }

    String createMsgForLogMethodDuration(String targetMethodName, long duration) {
        StringBuilder sb = new StringBuilder();
        sb.append(targetMethodName).append("(): ");
        sb.append("duration ").append(duration).append(" ms");
        return sb.toString();
    }

    static void setLogger(Logger logger) {
        AbstractAopMethodLogger.logger = logger;
    }
}

