/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springsecurity.access;

import de.digitalcollections.commons.springsecurity.access.UnsecuredPathsConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableConfigurationProperties(value={UnsecuredPathsConfig.class})
public class UnsecuredPaths {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsecuredPaths.class);
    private final UnsecuredPathsConfig unsecuredPathsConfig;
    private List<String> unsecuredPaths = new ArrayList<String>();

    @Autowired
    public UnsecuredPaths(UnsecuredPathsConfig unsecuredPathsConfig) {
        this.unsecuredPathsConfig = unsecuredPathsConfig;
    }

    @PostConstruct
    void init() {
        if (this.unsecuredPathsConfig.getUnsecured() != null) {
            this.unsecuredPaths = this.unsecuredPathsConfig.getUnsecured();
        } else {
            this.unsecuredPaths.addAll(Arrays.asList("/health", "/info", "/javamelody", "/jolokia", "/jolokia/**", "/jsondoc", "/monitoring**", "/monitoring/health", "/monitoring/jolokia", "/monitoring/jolokia/**", "/monitoring/prometheus", "/monitoring/prometheus/**", "/monitoring/version", "/resources/**", "/version"));
        }
        LOGGER.info("Unsecured paths=" + this.unsecuredPaths);
    }

    public List<String> getUnsecuredPaths() {
        return this.unsecuredPaths;
    }

    public void clearUnsecuredPaths() {
        this.unsecuredPaths.clear();
    }

    public void addUnsecuredPath(String pathToAdd) {
        this.unsecuredPaths.add(pathToAdd);
    }
}

