/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springmvc.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CurrentUrlAsModelAttributeHandlerInterceptor
extends HandlerInterceptorAdapter {
    List<String> paramsToBeDeleted = new ArrayList<String>();

    public void deleteParams(String ... params) {
        if (params != null) {
            this.paramsToBeDeleted = Arrays.asList(params);
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            String currentUrl = this.getCurrentUrl(request);
            modelAndView.addObject("currentUrl", (Object)currentUrl);
        }
    }

    private String getCurrentUrl(HttpServletRequest request) {
        String contextPath;
        Object currentUrl = request.getRequestURI();
        if (request.getQueryString() != null) {
            currentUrl = (String)currentUrl + "?" + request.getQueryString();
        }
        if ((contextPath = request.getContextPath()).length() > 1) {
            currentUrl = ((String)currentUrl).replaceFirst(contextPath, "");
        }
        for (String param : this.paramsToBeDeleted) {
            String paramValue = request.getParameter(param);
            currentUrl = this.deleteParam(param, paramValue, (String)currentUrl);
        }
        return currentUrl;
    }

    protected String deleteParam(String paramName, String paramValue, String currentUrl) {
        if (paramName != null) {
            if (paramValue == null) {
                paramValue = "";
            }
            currentUrl = currentUrl.replaceAll("&" + paramName + "=" + paramValue, "");
            currentUrl = currentUrl.replaceAll("\\?" + paramName + "=" + paramValue + "&", "?");
            currentUrl = currentUrl.replaceAll("\\?" + paramName + "=" + paramValue, "");
        }
        return currentUrl;
    }
}

