/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springmvc.converter;

import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.NullHandling;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.convert.converter.Converter;

public class StringToOrderConverter
implements Converter<String, Order> {
    private final Pattern ORDER_PATTERN = Pattern.compile("^(?i)(?<property>[a-z]+)(_(?<subProperty>[a-z\\-]+))?(\\.(?<direction>asc|desc))?(\\.(?<nullHandling>nullsfirst|nullslast))?(\\.(?<ignoreCase>ignorecase))?$");

    public Order convert(String source) {
        String direction;
        if (source == null) {
            return null;
        }
        Matcher matcher = this.ORDER_PATTERN.matcher(source);
        if (!matcher.matches()) {
            return null;
        }
        Order.OrderBuilder order = Order.builder();
        String property = matcher.group("property");
        order.property(property);
        String subProperty = matcher.group("subProperty");
        if (subProperty != null) {
            order.subProperty(subProperty);
        }
        if ((direction = matcher.group("direction")) != null) {
            order.direction(Direction.fromString((String)direction));
        } else {
            order.direction(Sorting.DEFAULT_DIRECTION);
        }
        String nullHandling = matcher.group("nullHandling");
        if (nullHandling != null) {
            if ("nullsfirst".equals(nullHandling.toLowerCase())) {
                order.nullHandling(NullHandling.NULLS_FIRST);
            } else {
                order.nullHandling(NullHandling.NULLS_LAST);
            }
        } else {
            order.nullHandling(NullHandling.NATIVE);
        }
        String ignoreCase = matcher.group("ignoreCase");
        if (ignoreCase != null) {
            order.ignoreCase(Boolean.valueOf(true));
        } else {
            order.ignoreCase(Boolean.valueOf(false));
        }
        return order.build();
    }
}

