/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springmvc.interceptors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class RequestProcessingTimeInterceptor
extends HandlerInterceptorAdapter
implements ResponseBodyAdvice<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestProcessingTimeInterceptor.class);

    public Object beforeBodyWrite(Object body, MethodParameter mp, MediaType mt, Class<? extends HttpMessageConverter<?>> type, ServerHttpRequest request, ServerHttpResponse response) {
        long startTime = (Long)((ServletServerHttpRequest)request).getServletRequest().getAttribute("startTime");
        long duration = System.currentTimeMillis() - startTime;
        response.getHeaders().add("x-execution-duration", duration + " ms");
        return body;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long startTime = System.currentTimeMillis();
        LOGGER.debug("request URL={} :: Start Time={}", (Object)request.getRequestURL().toString(), (Object)System.currentTimeMillis());
        request.setAttribute("startTime", (Object)startTime);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        LOGGER.debug("request URL={} :: Sent to Handler :: Current Time={}", (Object)request.getRequestURL().toString(), (Object)System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (request.getMethod().equals("HEAD")) {
            return;
        }
        try {
            long startTime = (Long)request.getAttribute("startTime");
            LOGGER.debug("request URL={} :: End Time={}", (Object)request.getRequestURL().toString(), (Object)System.currentTimeMillis());
            long duration = System.currentTimeMillis() - startTime;
            MDC.put((String)"request_url", (String)request.getRequestURL().toString());
            MDC.put((String)"processing_time", (String)String.valueOf(duration));
            LOGGER.info("request URL={} :: processing time={} ms", (Object)request.getRequestURL().toString(), (Object)duration);
        }
        finally {
            MDC.clear();
        }
    }

    public boolean supports(MethodParameter mp, Class<? extends HttpMessageConverter<?>> type) {
        return true;
    }
}

