/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springdata.domain;

import de.digitalcollections.commons.springdata.domain.SortConverter;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableConverter {
    public static PageRequest convert(Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        int pageNumber = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        Sort sort = pageable.getSort();
        Sorting sorting = SortConverter.convert(sort);
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, sorting);
        return pageRequest;
    }

    public static PageRequest convert(Pageable pageable, int defaultPageSize, String defaultSortField) {
        PageRequest pageRequest = PageableConverter.convert(pageable);
        if (pageRequest.getPageSize() == -1 && defaultPageSize != -1) {
            pageRequest.setPageSize(defaultPageSize);
        }
        if (pageRequest.getSorting() == null && defaultSortField != null) {
            SortingImpl sorting = new SortingImpl(new String[]{defaultSortField});
            pageRequest.setSorting((Sorting)sorting);
        }
        return pageRequest;
    }

    public static Pageable convert(PageRequest pageRequest) {
        if (pageRequest == null) {
            return null;
        }
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        Sorting sorting = pageRequest.getSorting();
        Sort sort = SortConverter.convert(sorting);
        org.springframework.data.domain.PageRequest pageable = new org.springframework.data.domain.PageRequest(pageNumber, pageSize, sort);
        return pageable;
    }
}

