/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springboot.monitoring;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ManagedResource(objectName="Service:type=JMX,name=VersionInfo")
public class VersionInfo {
    @Value(value="${info.app.project.artifactId:unknown}")
    private String projectArtifactId;
    @Value(value="${info.app.project.version:unknown}")
    private String projectVersion;
    private String projectBuildDetails;
    @Value(value="${info.app.project.name:}")
    private String projectName;
    @Autowired
    private AbstractEnvironment env;
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionInfo.class);
    private static final Pattern JAR_PATTERN = Pattern.compile(".*/(.*?)!");
    private static final Pattern VERSION_FROM_FILENAME_PATTERN = Pattern.compile("(.*)-([^SR].*)\\.jar$");
    private static final String[] VERSION_KEYS = new String[]{"Implementation-Version", "Bundle-Version", "Version"};
    Map<String, String> versions = new TreeMap<String, String>();

    @PostConstruct
    public void init() {
        this.env.setIgnoreUnresolvableNestedPlaceholders(true);
        this.projectBuildDetails = this.env.getProperty("info.app.project.buildDetails");
        this.versions.put(this.projectArtifactId, this.projectBuildDetails);
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest = new Manifest(is);
                    Attributes manifestAttributes = manifest.getMainAttributes();
                    String artifactName = this.getArtifactNameFromUrl(url);
                    String version = this.extractVersionFromManifest(manifestAttributes, artifactName);
                    this.versions.put(artifactName, version);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot read manifests: " + e, (Throwable)e);
        }
        LOGGER.info("Version=" + this.projectVersion);
    }

    @ManagedAttribute
    public String getVersionInfo() {
        return this.projectVersion;
    }

    @ManagedAttribute
    public String getApplicationName() {
        return this.projectName;
    }

    @ManagedAttribute
    public String getBuildDetails() {
        return this.projectBuildDetails;
    }

    @ManagedAttribute
    public Map<String, String> getArtifactVersions() {
        return this.versions;
    }

    private String getArtifactNameFromUrl(URL url) {
        String path = url.getPath();
        Matcher matcher = JAR_PATTERN.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "unknown";
    }

    private String extractVersionFromManifest(Attributes attributes, String fallback) {
        for (String versionKey : VERSION_KEYS) {
            String version = attributes.getValue(versionKey);
            if (StringUtils.isEmpty((Object)version)) continue;
            return version;
        }
        Matcher matcher = VERSION_FROM_FILENAME_PATTERN.matcher(fallback);
        if (matcher.find()) {
            return "~ " + matcher.group(2);
        }
        return "unknown (tried everything)";
    }
}

