/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.springboot.metrics;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class MetricsService {
    protected Map<String, Long> counters = new HashMap<String, Long>();
    protected Map<String, Set<Tag>> counterTags = new HashMap<String, Set<Tag>>();
    protected Map<String, Timer> timers = new HashMap<String, Timer>();
    private final MeterRegistry meterRegistry;

    public MetricsService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void setGauge(String name, long value) {
        this.handleCounter(name, null, null, value, null, false);
    }

    public void setGauge(String name, String tag, long value) {
        this.handleCounter(name, tag, null, value, null, false);
    }

    public void increaseCounter(String name, String tag) {
        this.handleCounter(name, tag, 1L, null, null, false);
    }

    public void increaseCounter(String name, String tag, long increment) {
        this.handleCounter(name, tag, increment, null, null, false);
    }

    public void increaseCounterWithDuration(String name, String tag, Long durationMillis) {
        this.handleCounter(name, tag, 1L, null, durationMillis, false);
    }

    public void increaseCounterWithDurationAndPercentiles(String name, String tag, Long durationMillis) {
        this.handleCounter(name, tag, 1L, null, durationMillis, true);
    }

    private void handleCounter(String name, String tag, Long increment, Long absoluteValue, Long durationMillis, Boolean publishPercentiles) {
        String key = name + (tag != null ? "." + tag : "");
        if (increment != null) {
            this.counters.put(key, this.counters.getOrDefault(key, 0L) + increment);
        } else {
            this.counters.put(key, absoluteValue);
        }
        if (this.counterTags.get(key) == null) {
            this.counterTags.put(key, new HashSet());
            if (tag != null) {
                this.counterTags.get(key).add((Tag)new ImmutableTag("type", tag));
                this.meterRegistry.gauge(name + ".amount", (Iterable)this.counterTags.get(key), (Object)key, this.counters::get);
            } else {
                this.meterRegistry.gauge(name + ".amount", (Number)this.counters.get(key));
            }
        }
        if (durationMillis != null && tag != null) {
            if (this.timers.get(key) == null) {
                Timer.Builder timerBuilder = Timer.builder((String)(name + ".duration")).tag("type", tag);
                if (publishPercentiles.booleanValue()) {
                    timerBuilder = timerBuilder.publishPercentiles(new double[]{0.5, 0.95}).publishPercentileHistogram();
                }
                Timer timer = timerBuilder.register(this.meterRegistry);
                this.timers.put(key, timer);
            }
            this.timers.get(key).record(durationMillis.longValue(), TimeUnit.MILLISECONDS);
        }
    }

    protected Map<String, Long> getCounters() {
        return this.counters;
    }

    protected Map<String, Set<Tag>> getCounterTags() {
        return this.counterTags;
    }

    protected Map<String, Timer> getTimers() {
        return this.timers;
    }
}

