/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.commons.server;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.record.Location;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HttpLoggingUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpLoggingUtilities.class);
    private static boolean LOOKUP_LOCATION = true;
    private static DatabaseReader GEO_IP_DATABASE = null;

    protected static boolean isValidPublicIp(String ip) {
        InetAddress address;
        try {
            address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException exception) {
            return false;
        }
        return !address.isSiteLocalAddress() && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }

    protected static String anonymizeIp(String ip) {
        return ip.replaceAll("(\\d+)\\.(\\d+)\\..*", "$1.$2");
    }

    public static void addRequestClientInfoToMDC(HttpServletRequest request) {
        String protocol = request.getHeader("X-Forwarded-Proto");
        if (protocol == null) {
            protocol = request.getProtocol();
        }
        MDC.put((String)"protocol", (String)protocol);
        String ipString = request.getHeader("X-Forwarded-For");
        if (ipString == null) {
            ipString = request.getRemoteAddr();
        }
        MDC.put((String)"anonymizedClientIp", (String)HttpLoggingUtilities.anonymizeIp(ipString));
        MDC.put((String)"userAgent", (String)request.getHeader("User-Agent"));
        MDC.put((String)"referer", (String)request.getHeader("Referer"));
        if (LOOKUP_LOCATION) {
            if (GEO_IP_DATABASE == null) {
                try {
                    InputStream dbStream = HttpLoggingUtilities.class.getResourceAsStream("/geolite2/GeoLite2-City.mmdb");
                    GEO_IP_DATABASE = new DatabaseReader.Builder(dbStream).build();
                }
                catch (Throwable e) {
                    LOOKUP_LOCATION = false;
                    LOGGER.error("Could not open GeoIP database", e);
                }
            }
            if (HttpLoggingUtilities.isValidPublicIp(ipString)) {
                try {
                    InetAddress clientIp = InetAddress.getByName(ipString);
                    Location clientLocation = GEO_IP_DATABASE.city(clientIp).getLocation();
                    MDC.put((String)"ipLatitude", (String)String.valueOf(clientLocation.getLatitude()));
                    MDC.put((String)"ipLongitude", (String)String.valueOf(clientLocation.getLongitude()));
                }
                catch (GeoIp2Exception | IOException e) {
                    LOGGER.warn("Could not retrieve geo information for IP {}", (Object)ipString);
                }
            }
        }
    }
}

