/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.prosemirror.model.impl.contentblocks;

import de.digitalcollections.prosemirror.model.api.Mark;
import de.digitalcollections.prosemirror.model.api.contentblocks.Text;
import de.digitalcollections.prosemirror.model.impl.ContentBlockImpl;
import de.digitalcollections.prosemirror.model.impl.MarkImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TextImpl
extends ContentBlockImpl
implements Text {
    private String text;
    private List<Mark> marks;

    public TextImpl() {
    }

    public TextImpl(String text) {
        this.text = text;
    }

    public TextImpl(String text, String ... marks) {
        this(text);
        if (marks != null) {
            for (String markStr : marks) {
                MarkImpl mark = new MarkImpl(markStr);
                this.addMark(mark);
            }
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public List<Mark> getMarks() {
        return this.marks;
    }

    @Override
    public void setMarks(List<Mark> marks) {
        this.marks = marks;
    }

    @Override
    public void addMark(Mark mark) {
        if (this.marks == null) {
            this.marks = new ArrayList<Mark>();
        }
        this.marks.add(mark);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextImpl)) {
            return false;
        }
        TextImpl text1 = (TextImpl)o;
        return Objects.equals(this.text, text1.text) && Objects.equals(this.marks, text1.marks);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.marks);
    }

    public String toString() {
        return "TextImpl{text='" + this.text + "', marks=" + this.marks + ", hashCode=" + this.hashCode() + '}';
    }
}

