/*
 * Decompiled with CFR 0.152.
 */
package de.devsurf.injection.guice.scanner.reflections;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import de.devsurf.injection.guice.scanner.AnnotationListener;
import de.devsurf.injection.guice.scanner.ClasspathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ReflectionsScanner
implements ClasspathScanner {
    private Logger _logger = Logger.getLogger(ReflectionsScanner.class.getName());
    private LinkedList<AnnotationListener> _listeners;
    private LinkedList<Pattern> packagePatterns;
    private String[] _packages;

    @Inject
    public ReflectionsScanner(Set<AnnotationListener> listeners, String ... packages) {
        this._listeners = new LinkedList<AnnotationListener>(listeners);
        this._packages = packages;
        this.packagePatterns = new LinkedList();
        for (String p : packages) {
            this.includePackage(p);
        }
    }

    public void addAnnotationListener(AnnotationListener listener) {
        this._listeners.add(listener);
    }

    public void removeAnnotationListener(AnnotationListener listener) {
        this._listeners.remove(listener);
    }

    public List<AnnotationListener> getAnnotationListeners() {
        return new ArrayList<AnnotationListener>(this._listeners);
    }

    public void excludePackage(String packageName) {
    }

    public void includePackage(String packageName) {
        String pattern = ".*" + packageName.replace(".", "\\.") + ".*";
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Including Package for scanning: " + packageName + " generating Pattern: " + pattern);
        }
        this.packagePatterns.add(Pattern.compile(pattern));
    }

    public void scan() throws IOException {
        LinkedHashSet urls = new LinkedHashSet();
        for (String p : this._packages) {
            urls.addAll(ClasspathHelper.getUrlsForPackagePrefix((String)p));
        }
        new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new AnnotationScanner()}).filterInputsBy((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return ReflectionsScanner.this.matches(input);
            }
        }).setUrls(urls).useParallelExecutor());
    }

    private boolean matches(String name) {
        for (Pattern pattern : this.packagePatterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private class AnnotationScanner
    extends AbstractScanner {
        private AnnotationScanner() {
        }

        public void scan(Object cls) {
            Class<?> objectClass;
            ClassFile classFile = (ClassFile)cls;
            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
            if (annotationsAttribute == null) {
                return;
            }
            try {
                objectClass = Class.forName(classFile.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            HashMap map = new HashMap();
            for (Annotation annotation : annotationsAttribute.getAnnotations()) {
                try {
                    Class<?> annotationClass = Class.forName(annotation.getTypeName());
                    map.put(annotationClass.getName(), objectClass.getAnnotation(annotationClass));
                }
                catch (ClassNotFoundException e) {
                    ReflectionsScanner.this._logger.log(Level.WARNING, "Failure while trying to load the Annotations from Classpath.", e);
                }
            }
            for (AnnotationListener listener : ReflectionsScanner.this._listeners) {
                listener.found(objectClass, map);
            }
        }
    }
}

