/**
 * Copyright (C) 2010 Daniel Manzke <daniel.manzke@googlemail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.saperion.components.converter;

public interface ConverterFormat {
	public String getName();
	public String getFileExtensions();
	public String getMimeType();
	
	public static abstract class AbstractFormat implements ConverterFormat{
		protected final String _name;
		protected final String _extension;
		protected final String _mimeType;
		
		public AbstractFormat(String name, String extension, String mimeType) {
			super();
			_name = name;
			_extension = extension;
			_mimeType = mimeType;
		}
		
		@Override
		public String getName() {
			return _name;
		}
		
		@Override
		public String getFileExtensions() {
			return _extension;
		}
		
		@Override
		public String getMimeType() {
			return _mimeType;
		}
	}
	
	public static class InputFormat extends AbstractFormat{
		public InputFormat(String name, String extension, String mimeType) {
			super(name, extension, mimeType);
		}
	}
	
	public static class OutputFormat extends AbstractFormat{
		public OutputFormat(String name, String extension, String mimeType) {
			super(name, extension, mimeType);
		}
	}
}
