/**
 * Copyright (C) 2010 Daniel Manzke <daniel.manzke@googlemail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.saperion.components.converter;

import java.io.InputStream;
import java.util.Set;

import com.saperion.components.converter.ConverterFormat.InputFormat;
import com.saperion.components.converter.ConverterFormat.OutputFormat;

import de.devsurf.tools.io.NamedInputStream;

public interface Converter {
	public Set<ConverterFormat> getSupportedFormats();
	public boolean supports(ConverterFormat format);
	public InputStream convert(NamedInputStream in, InputFormat inputFormat, OutputFormat outputFormat) throws Exception;
	public void initialize() throws Exception;
	public void shutdown() throws Exception;
}
