/*
 * Decompiled with CFR 0.152.
 */
package de.dev.eth0.jcodegen.elements;

import de.dev.eth0.jcodegen.constants.Modifier;
import de.dev.eth0.jcodegen.elements.AbstractStandaloneElement;
import de.dev.eth0.jcodegen.elements.EnumerationEntry;
import de.dev.eth0.jcodegen.elements.Field;
import de.dev.eth0.jcodegen.elements.interfaces.ComplexElement;
import de.dev.eth0.jcodegen.elements.interfaces.StandaloneElement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enumeration
extends AbstractStandaloneElement<Enumeration>
implements ComplexElement,
StandaloneElement {
    private final Set<EnumerationEntry> mEntries = new LinkedHashSet<EnumerationEntry>();

    public Enumeration(String pName) {
        this((String)null, pName);
    }

    public Enumeration(String pPackage, String pName) {
        super(pPackage, "enum", pName);
    }

    public Enumeration addEntry(EnumerationEntry pEntry) {
        if (pEntry != null) {
            this.mEntries.add(pEntry);
        }
        return this;
    }

    public Set<EnumerationEntry> getEntries() {
        return Collections.unmodifiableSet(this.mEntries);
    }

    @Override
    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.getPackage())) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder(super.toString());
        for (Modifier mod : this.getModifier()) {
            sb.append((Object)mod);
            sb.append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getType())) {
            sb.append(this.getType());
            sb.append(" ");
        }
        sb.append(this.getName());
        this.printOutElementContent(sb);
        return sb.toString();
    }

    @Override
    protected void printOutElementContent(StringBuilder pStringBuilder) {
        pStringBuilder.append(" ");
        if (!this.getImplements().isEmpty()) {
            pStringBuilder.append("implements ");
            pStringBuilder.append(this.getCommaSeperated(this.getImplements()));
        }
        pStringBuilder.append("{\n\n");
        if (!this.mEntries.isEmpty()) {
            int count = this.mEntries.size();
            for (EnumerationEntry entry : this.mEntries) {
                pStringBuilder.append(entry);
                if (--count <= 0) continue;
                pStringBuilder.append(",\n");
            }
            pStringBuilder.append(";\n");
        }
        pStringBuilder.append("\n");
        for (Field field : this.getFields()) {
            pStringBuilder.append(field.toString());
        }
        pStringBuilder.append("\n");
        for (ComplexElement elem : this.getElements()) {
            pStringBuilder.append(elem);
            pStringBuilder.append("\n");
        }
        pStringBuilder.append("}");
    }
}

