/*
 * Decompiled with CFR 0.152.
 */
package de.dev.eth0.jcodegen.elements;

import de.dev.eth0.jcodegen.constants.Modifier;
import de.dev.eth0.jcodegen.elements.AbstractBasicElementWithComments;
import de.dev.eth0.jcodegen.elements.interfaces.ElementWithModifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicElementWithModifier<T extends AbstractBasicElementWithModifier>
extends AbstractBasicElementWithComments<T>
implements ElementWithModifier {
    private Set<Modifier> mModifier = new LinkedHashSet<Modifier>();
    private final String mName;
    private final String mType;

    public AbstractBasicElementWithModifier(String pType, String pName) {
        this.mName = pName;
        this.mType = pType;
    }

    public AbstractBasicElementWithModifier(Class pType, String pName) {
        this.mType = pType.getSimpleName();
        this.mName = pName;
    }

    public T addModifier(Modifier pModifier) {
        this.mModifier.add(pModifier);
        return (T)this;
    }

    @Override
    public Set<Modifier> getModifier() {
        return Collections.unmodifiableSet(this.mModifier);
    }

    public String getName() {
        return this.mName;
    }

    public String getType() {
        return this.mType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (Modifier mod : this.getModifier()) {
            sb.append((Object)mod);
            sb.append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.mType)) {
            sb.append(this.mType);
            sb.append(" ");
        }
        sb.append(this.mName);
        this.printOutElementContent(sb);
        return sb.toString();
    }

    protected abstract void printOutElementContent(StringBuilder var1);
}

