/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.varlink.maven;

import de.dentrassi.varlink.generator.Generator;
import de.dentrassi.varlink.generator.JdtGenerator;
import de.dentrassi.varlink.maven.Loader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.emf.ecore.resource.Resource;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(defaultPhase=LifecyclePhase.GENERATE_SOURCES, name="generate", requiresProject=true)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(property="varlink.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="varlink.generator.charset", required=true, defaultValue="${project.build.sourceEncoding}")
    private String characterSet;
    @Parameter(required=true, property="varlink.targetPath", defaultValue="${project.build.directory}/generated-sources/varlink")
    private File targetPath;
    @Parameter(required=true, property="varlink.sourcePath", defaultValue="${basedir}/src/main/varlink")
    private File sourcePath;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private BuildContext buildContext;

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setTargetPath(File targetPath) {
        this.targetPath = targetPath;
    }

    public File getTargetPath() {
        return this.targetPath;
    }

    public void setSourcePath(File sourcePath) {
        this.sourcePath = sourcePath;
    }

    public File getSourcePath() {
        return this.sourcePath;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            final Loader loader = new Loader();
            final HashMap errors = new HashMap();
            Files.walkFileTree(this.sourcePath.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    List<Resource.Diagnostic> localErrors = loader.loadFrom(file);
                    if (!localErrors.isEmpty()) {
                        errors.put(file.toString(), localErrors);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (!errors.isEmpty()) {
                for (Map.Entry entry : errors.entrySet()) {
                    for (Resource.Diagnostic diag : (List)entry.getValue()) {
                        String location = diag.getLocation();
                        if (location == null) {
                            location = (String)entry.getKey();
                        }
                        this.getLog().error((CharSequence)String.format("%s:%s:%s: %s", location, diag.getLine(), diag.getColumn(), diag.getMessage()));
                    }
                }
                throw new MojoFailureException("Failed to validate models. See log for more information.");
            }
            Generator.Options options = new Generator.Options();
            if (this.characterSet != null) {
                options.setCharacterSet(Charset.forName(this.characterSet));
            }
            if (this.targetPath != null) {
                options.setTargetPath(this.targetPath.toPath());
            }
            JdtGenerator generator = new JdtGenerator(options);
            generator.generateAll(loader);
            this.project.addCompileSourceRoot(this.targetPath.getAbsolutePath());
            this.buildContext.refresh(this.targetPath.getAbsoluteFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate", e);
        }
    }
}

