/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.varlink.generator.util;

import de.dentrassi.varlink.generator.util.Names;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JdtHelper {
    public static StringLiteral newStringLiteral(AST ast, String value) {
        StringLiteral result = ast.newStringLiteral();
        result.setLiteralValue(value);
        return result;
    }

    public static void make(AST ast, List<? super Object> decl, Modifier.ModifierKeyword ... keywords) {
        for (Modifier.ModifierKeyword keyword : keywords) {
            decl.add(ast.newModifier(keyword));
        }
    }

    public static void make(BodyDeclaration decl, Modifier.ModifierKeyword ... keywords) {
        JdtHelper.make(decl.getAST(), decl.modifiers(), keywords);
    }

    public static void make(SingleVariableDeclaration decl, Modifier.ModifierKeyword ... keywords) {
        JdtHelper.make(decl.getAST(), decl.modifiers(), keywords);
    }

    public static void addSimpleAnnotation(BodyDeclaration decl, String name) {
        AST ast = decl.getAST();
        MarkerAnnotation ann = ast.newMarkerAnnotation();
        ann.setTypeName(ast.newName(name));
        decl.modifiers().add(ann);
    }

    public static NormalAnnotation addAnnotation(BodyDeclaration decl, String name) {
        AST ast = decl.getAST();
        NormalAnnotation ann = ast.newNormalAnnotation();
        ann.setTypeName(ast.newName(name));
        decl.modifiers().add(ann);
        return ann;
    }

    public static void createCompilationUnit(Path root, String packageName, String name, Charset charset, BiConsumer<AST, CompilationUnit> consumer) {
        AST ast = AST.newAST((int)8);
        CompilationUnit cu = ast.newCompilationUnit();
        PackageDeclaration pkg = ast.newPackageDeclaration();
        pkg.setName(ast.newName(packageName));
        cu.setPackage(pkg);
        Path path = root.resolve(packageName.replace(".", File.separator)).resolve(name + ".java");
        consumer.accept(ast, cu);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            CodeFormatter formatter = ToolFactory.createCodeFormatter(null);
            String s = cu.toString();
            TextEdit result = formatter.format(8, s, 0, s.length(), 0, null);
            Document doc = new Document(s);
            result.apply((IDocument)doc);
            try (BufferedWriter writer = Files.newBufferedWriter(path, charset, new OpenOption[0]);){
                writer.append(doc.get());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void createField(TypeDeclaration decl, String typeName, String fieldName, Modifier.ModifierKeyword ... keywords) {
        AST ast = decl.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(fieldName));
        FieldDeclaration fd = ast.newFieldDeclaration(fragment);
        fd.setType((Type)ast.newSimpleType(ast.newName(typeName)));
        JdtHelper.make((BodyDeclaration)fd, keywords);
        decl.bodyDeclarations().add(fd);
    }

    public static void createParameter(MethodDeclaration decl, Type type, String name, Modifier.ModifierKeyword ... keywords) {
        AST ast = decl.getAST();
        SingleVariableDeclaration svd = ast.newSingleVariableDeclaration();
        svd.setType(type);
        svd.setName(ast.newSimpleName(name));
        JdtHelper.make(svd, keywords);
        decl.parameters().add(svd);
    }

    public static void createParameter(MethodDeclaration decl, String typeName, String name, Modifier.ModifierKeyword ... keywords) {
        AST ast = decl.getAST();
        JdtHelper.createParameter(decl, (Type)ast.newSimpleType(ast.newName(typeName)), name, keywords);
    }

    public static void createThisAssignment(Block body, String name) {
        AST ast = body.getAST();
        Assignment as = ast.newAssignment();
        FieldAccess fa = ast.newFieldAccess();
        fa.setExpression((Expression)ast.newThisExpression());
        fa.setName(ast.newSimpleName(name));
        as.setLeftHandSide((Expression)fa);
        as.setRightHandSide((Expression)ast.newSimpleName(name));
        body.statements().add(ast.newExpressionStatement((Expression)as));
    }

    public static <T extends ASTNode> T copyNode(AST ast, T node) {
        return (T)ASTNode.copySubtree((AST)ast, node);
    }

    public static MethodDeclaration createGetter(AST ast, Type type, String name) {
        MethodDeclaration md = ast.newMethodDeclaration();
        md.setName(ast.newSimpleName("get" + Names.toUpperFirst(name)));
        JdtHelper.make((BodyDeclaration)md, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        md.setReturnType2(type);
        Block body = ast.newBlock();
        md.setBody(body);
        ReturnStatement ret = ast.newReturnStatement();
        body.statements().add(ret);
        FieldAccess fa = ast.newFieldAccess();
        fa.setExpression((Expression)ast.newThisExpression());
        fa.setName(ast.newSimpleName(name));
        ret.setExpression((Expression)fa);
        return md;
    }
}

