/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.varlink.generator;

import de.dentrassi.varlink.generator.Generator;
import de.dentrassi.varlink.generator.util.JdtHelper;
import de.dentrassi.varlink.generator.util.Names;
import de.dentrassi.varlink.idl.varlinkIdl.Array;
import de.dentrassi.varlink.idl.varlinkIdl.BasicType;
import de.dentrassi.varlink.idl.varlinkIdl.Dictionary;
import de.dentrassi.varlink.idl.varlinkIdl.ElementType;
import de.dentrassi.varlink.idl.varlinkIdl.Enum;
import de.dentrassi.varlink.idl.varlinkIdl.Error;
import de.dentrassi.varlink.idl.varlinkIdl.Field;
import de.dentrassi.varlink.idl.varlinkIdl.Interface;
import de.dentrassi.varlink.idl.varlinkIdl.Method;
import de.dentrassi.varlink.idl.varlinkIdl.Object;
import de.dentrassi.varlink.idl.varlinkIdl.Optional;
import de.dentrassi.varlink.idl.varlinkIdl.TypeAlias;
import de.dentrassi.varlink.idl.varlinkIdl.TypeAliasDefinition;
import de.dentrassi.varlink.idl.varlinkIdl.TypeReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class JdtGenerator
implements Generator {
    private static final String TYPE_TOKEN_TYPE_NAME = "com.google.gson.reflect.TypeToken";
    private final Generator.Options options;

    public JdtGenerator(Generator.Options options) {
        Objects.requireNonNull(options);
        this.options = new Generator.Options(options);
        this.options.validate();
    }

    private static String internalMethodName(String name) {
        return "internal" + Names.toUpperFirst(name);
    }

    @Override
    public void generate(Interface iface) {
        LinkedList<String> toks = new LinkedList<String>(Arrays.asList(iface.getName().split("\\.")));
        String name = Names.toUpperFirst(toks.getLast());
        String packageName = iface.getName();
        JdtHelper.createCompilationUnit(this.options.getTargetPath(), packageName, name, this.options.getCharacterSet(), (ast, cu) -> this.createInterface((AST)ast, (CompilationUnit)cu, iface, name));
        JdtHelper.createCompilationUnit(this.options.getTargetPath(), packageName, name + "Impl", this.options.getCharacterSet(), (ast, cu) -> this.createImpl((AST)ast, (CompilationUnit)cu, iface, name));
    }

    private void createImpl(AST ast, CompilationUnit cu, Interface iface, String name) {
        String implName = name + "Impl";
        TypeDeclaration td = ast.newTypeDeclaration();
        cu.types().add(td);
        td.setName(ast.newSimpleName(implName));
        JdtHelper.make((BodyDeclaration)td, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        SimpleType parentType = ast.newSimpleType(ast.newName(name));
        td.superInterfaceTypes().add(parentType);
        this.createImplFactory(ast, td);
        JdtHelper.createField(td, "de.dentrassi.varlink.spi.Connection", "connection", Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        JdtHelper.createField(td, "de.dentrassi.varlink.internal.VarlinkImpl", "varlink", Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        MethodDeclaration ctor = ast.newMethodDeclaration();
        td.bodyDeclarations().add(ctor);
        ctor.setConstructor(true);
        ctor.setName(ast.newSimpleName(implName));
        JdtHelper.make((BodyDeclaration)ctor, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        JdtHelper.createParameter(ctor, "de.dentrassi.varlink.spi.Connection", "connection", Modifier.ModifierKeyword.FINAL_KEYWORD);
        JdtHelper.createParameter(ctor, "de.dentrassi.varlink.internal.VarlinkImpl", "varlink", Modifier.ModifierKeyword.FINAL_KEYWORD);
        Block body = ast.newBlock();
        ctor.setBody(body);
        JdtHelper.createThisAssignment(body, "connection");
        JdtHelper.createThisAssignment(body, "varlink");
        MethodDeclaration md2 = ast.newMethodDeclaration();
        JdtHelper.make((BodyDeclaration)md2, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        td.bodyDeclarations().add(md2);
        md2.setName(ast.newSimpleName("checkError"));
        JdtHelper.createParameter(md2, "de.dentrassi.varlink.spi.CallResponse", "response", Modifier.ModifierKeyword.FINAL_KEYWORD);
        Block body2 = ast.newBlock();
        md2.setBody(body2);
        MethodInvocation mi = ast.newMethodInvocation();
        mi.setExpression((Expression)ast.newName("de.dentrassi.varlink.spi.Errors"));
        mi.setName(ast.newSimpleName("checkErrors"));
        mi.arguments().add(ast.newSimpleName("response"));
        ExpressionMethodReference ref = ast.newExpressionMethodReference();
        ref.setExpression((Expression)ast.newThisExpression());
        ref.setName(ast.newSimpleName("mapError"));
        mi.arguments().add(ref);
        body2.statements().add(ast.newExpressionStatement((Expression)mi));
        md2 = ast.newMethodDeclaration();
        JdtHelper.make((BodyDeclaration)md2, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        td.bodyDeclarations().add(md2);
        md2.setName(ast.newSimpleName("mapError"));
        JdtHelper.createParameter(md2, "java.lang.String", "error", Modifier.ModifierKeyword.FINAL_KEYWORD);
        JdtHelper.createParameter(md2, "de.dentrassi.varlink.spi.CallResponse", "response", Modifier.ModifierKeyword.FINAL_KEYWORD);
        md2.setReturnType2((Type)ast.newSimpleType(ast.newName("java.lang.RuntimeException")));
        body2 = ast.newBlock();
        md2.setBody(body2);
        SwitchStatement sw = ast.newSwitchStatement();
        body2.statements().add(sw);
        sw.setExpression((Expression)ast.newSimpleName("error"));
        JdtGenerator.errors(iface).forEach(error -> {
            String errorName = this.errorTypeName((Error)error);
            String fullErrorName = iface.getName() + "." + errorName;
            SwitchCase sc = ast.newSwitchCase();
            sc.setExpression((Expression)JdtHelper.newStringLiteral(ast, fullErrorName));
            sw.statements().add(sc);
            FieldAccess fa = ast.newFieldAccess();
            fa.setExpression((Expression)ast.newThisExpression());
            fa.setName(ast.newSimpleName("varlink"));
            MethodInvocation fromJson = ast.newMethodInvocation();
            fromJson.setExpression((Expression)fa);
            fromJson.setName(ast.newSimpleName("fromJson"));
            TypeLiteral typeLiteral = ast.newTypeLiteral();
            typeLiteral.setType((Type)ast.newSimpleType(ast.newName(errorName + ".Parameters")));
            fromJson.arguments().add(typeLiteral);
            MethodInvocation parameters = ast.newMethodInvocation();
            parameters.setExpression((Expression)ast.newSimpleName("response"));
            parameters.setName(ast.newSimpleName("getParameters"));
            fromJson.arguments().add(parameters);
            ClassInstanceCreation cic = ast.newClassInstanceCreation();
            cic.setType((Type)ast.newSimpleType(ast.newName(errorName)));
            cic.arguments().add(fromJson);
            ReturnStatement ret = ast.newReturnStatement();
            ret.setExpression((Expression)cic);
            sw.statements().add(ret);
        });
        SwitchCase sc = ast.newSwitchCase();
        sc.setExpression(null);
        sw.statements().add(sc);
        ReturnStatement ret = ast.newReturnStatement();
        ret.setExpression((Expression)ast.newNullLiteral());
        sw.statements().add(ret);
        md2 = ast.newMethodDeclaration();
        td.bodyDeclarations().add(md2);
        md2.setName(ast.newSimpleName("async"));
        JdtHelper.addSimpleAnnotation((BodyDeclaration)md2, "Override");
        JdtHelper.make((BodyDeclaration)md2, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        md2.setReturnType2((Type)ast.newSimpleType(ast.newName("Async")));
        body2 = ast.newBlock();
        md2.setBody(body2);
        ReturnStatement ret2 = ast.newReturnStatement();
        body2.statements().add(ret2);
        ClassInstanceCreation cic = ast.newClassInstanceCreation();
        cic.setType((Type)ast.newSimpleType(ast.newName("Async")));
        ret2.setExpression((Expression)cic);
        AnonymousClassDeclaration acc = ast.newAnonymousClassDeclaration();
        cic.setAnonymousClassDeclaration(acc);
        JdtGenerator.forMethods(ast, iface, (m, amd) -> {
            acc.bodyDeclarations().add(amd);
            amd.setName(ast.newSimpleName(m.getName()));
            JdtHelper.make((BodyDeclaration)amd, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            this.makeAsync((MethodDeclaration)amd);
            Block asyncBody = ast.newBlock();
            amd.setBody(asyncBody);
            ReturnStatement asyncRet = ast.newReturnStatement();
            asyncBody.statements().add(asyncRet);
            MethodInvocation mi = ast.newMethodInvocation();
            mi.setName(ast.newSimpleName(JdtGenerator.internalMethodName(m.getName())));
            for (String argName : m.getParameters().keySet()) {
                mi.arguments().add(ast.newSimpleName(argName));
            }
            asyncRet.setExpression((Expression)mi);
        });
        JdtGenerator.forMethods(ast, iface, (m, md) -> {
            JdtHelper.make((BodyDeclaration)md, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
            td.bodyDeclarations().add(md);
            md.setName(ast.newSimpleName(JdtGenerator.internalMethodName(m.getName())));
            this.makeAsync((MethodDeclaration)md);
            this.createInternalMethod(td, (MethodInformation)m, (MethodDeclaration)md);
        });
    }

    private String errorTypeName(Error error) {
        return error.getName() + "Exception";
    }

    private void createInternalMethod(TypeDeclaration parentTypeDeclaration, MethodInformation m, MethodDeclaration md) {
        AST ast = md.getAST();
        Block body = ast.newBlock();
        md.setBody(body);
        if (!m.getParameters().isEmpty()) {
            VariableDeclarationFragment parameters = ast.newVariableDeclarationFragment();
            parameters.setName(ast.newSimpleName("parameters"));
            VariableDeclarationStatement decl = ast.newVariableDeclarationStatement(parameters);
            body.statements().add(decl);
            ParameterizedType map = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName("java.util.Map")));
            map.typeArguments().add(ast.newSimpleType(ast.newName("java.lang.String")));
            map.typeArguments().add(ast.newSimpleType(ast.newName("java.lang.Object")));
            decl.setType((Type)map);
            ClassInstanceCreation init = ast.newClassInstanceCreation();
            init.setType((Type)ast.newParameterizedType((Type)ast.newSimpleType(ast.newName("java.util.HashMap"))));
            init.arguments().add(ast.newNumberLiteral(Integer.toString(m.getParameters().size())));
            parameters.setInitializer((Expression)init);
            for (String argName : m.getParameters().keySet()) {
                MethodInvocation mi = ast.newMethodInvocation();
                mi.setExpression((Expression)ast.newSimpleName("parameters"));
                mi.setName(ast.newSimpleName("put"));
                mi.arguments().add(JdtHelper.newStringLiteral(ast, argName));
                mi.arguments().add(ast.newSimpleName(argName));
            }
        }
        ReturnStatement ret = ast.newReturnStatement();
        body.statements().add(ret);
        MethodInvocation mi = ast.newMethodInvocation();
        mi.setName(ast.newSimpleName("call"));
        FieldAccess fa = ast.newFieldAccess();
        fa.setExpression((Expression)ast.newThisExpression());
        fa.setName(ast.newSimpleName("connection"));
        mi.setExpression((Expression)fa);
        MethodInvocation cr = ast.newMethodInvocation();
        cr.setExpression((Expression)ast.newName("de.dentrassi.varlink.spi.CallRequest"));
        cr.setName(ast.newSimpleName("of"));
        cr.arguments().add(JdtHelper.newStringLiteral(ast, m.getInterface().getName() + "." + Names.toUpperFirst(m.getName())));
        if (!m.getParameters().isEmpty()) {
            cr.arguments().add(ast.newSimpleName("parameters"));
        }
        mi.arguments().add(cr);
        MethodInvocation thenApply = ast.newMethodInvocation();
        thenApply.setName(ast.newSimpleName("thenApply"));
        thenApply.setExpression((Expression)mi);
        LambdaExpression le = ast.newLambdaExpression();
        le.setParentheses(false);
        thenApply.arguments().add(le);
        VariableDeclarationFragment p = ast.newVariableDeclarationFragment();
        p.setName(ast.newSimpleName("result"));
        le.parameters().add(p);
        Block transform = ast.newBlock();
        le.setBody((ASTNode)transform);
        MethodInvocation check = ast.newMethodInvocation();
        check.setName(ast.newSimpleName("checkError"));
        transform.statements().add(ast.newExpressionStatement((Expression)check));
        check.arguments().add(ast.newSimpleName("result"));
        if (m.getReturnTypes().isEmpty()) {
            ReturnStatement transformRet = ast.newReturnStatement();
            transformRet.setExpression((Expression)ast.newNullLiteral());
            transform.statements().add(transformRet);
        } else {
            int returns = m.getReturnTypes().size();
            if (returns > 0) {
                FieldAccess varlink = ast.newFieldAccess();
                varlink.setExpression((Expression)ast.newThisExpression());
                varlink.setName(ast.newSimpleName("varlink"));
                MethodInvocation fromJson = ast.newMethodInvocation();
                fromJson.setExpression((Expression)varlink);
                fromJson.setName(ast.newSimpleName("fromJson"));
                ParameterizedType ttt = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName(TYPE_TOKEN_TYPE_NAME)));
                ttt.typeArguments().add(m.createMainReturnType(ast));
                ClassInstanceCreation tt = ast.newClassInstanceCreation();
                tt.setType((Type)JdtHelper.copyNode(ast, ttt));
                AnonymousClassDeclaration decl = ast.newAnonymousClassDeclaration();
                tt.setAnonymousClassDeclaration(decl);
                MethodInvocation getType = ast.newMethodInvocation();
                getType.setExpression((Expression)tt);
                getType.setName(ast.newSimpleName("getType"));
                VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
                vdf.setName(ast.newSimpleName(m.getName() + "_returnTypeToken"));
                vdf.setInitializer((Expression)getType);
                FieldDeclaration fd = ast.newFieldDeclaration(vdf);
                fd.setType((Type)ast.newSimpleType(ast.newName("java.lang.reflect.Type")));
                JdtHelper.make((BodyDeclaration)fd, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
                parentTypeDeclaration.bodyDeclarations().add(fd);
                fromJson.arguments().add(ast.newSimpleName(m.getName() + "_returnTypeToken"));
                MethodInvocation fragment = ast.newMethodInvocation();
                if (returns == 1) {
                    fragment.setName(ast.newSimpleName("getFirstParameter"));
                } else {
                    fragment.setName(ast.newSimpleName("getParameters"));
                }
                fragment.setExpression((Expression)ast.newSimpleName("result"));
                fromJson.arguments().add(fragment);
                ReturnStatement transformRet = ast.newReturnStatement();
                transformRet.setExpression((Expression)fromJson);
                transform.statements().add(transformRet);
            }
        }
        ret.setExpression((Expression)thenApply);
    }

    private void createImplFactory(AST ast, TypeDeclaration td) {
        TypeDeclaration ftd = ast.newTypeDeclaration();
        td.bodyDeclarations().add(ftd);
        ftd.setName(ast.newSimpleName("Factory"));
        JdtHelper.make((BodyDeclaration)ftd, Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
        ftd.superInterfaceTypes().add(ast.newSimpleType(ast.newName("de.dentrassi.varlink.spi.Factory")));
        MethodDeclaration md = ast.newMethodDeclaration();
        ftd.bodyDeclarations().add(md);
        md.setName(ast.newSimpleName("create"));
        md.setReturnType2((Type)ast.newSimpleType(ast.newName("T")));
        JdtHelper.make((BodyDeclaration)md, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        JdtHelper.addSimpleAnnotation((BodyDeclaration)md, "Override");
        TypeParameter tp = ast.newTypeParameter();
        tp.setName(ast.newSimpleName("T"));
        md.typeParameters().add(tp);
        ParameterizedType clazz = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName("Class")));
        clazz.typeArguments().add(ast.newSimpleType(ast.newName("T")));
        JdtHelper.createParameter(md, "de.dentrassi.varlink.internal.VarlinkImpl", "varlink", Modifier.ModifierKeyword.FINAL_KEYWORD);
        JdtHelper.createParameter(md, (Type)clazz, "clazz", Modifier.ModifierKeyword.FINAL_KEYWORD);
        JdtHelper.createParameter(md, "de.dentrassi.varlink.spi.Connection", "connection", Modifier.ModifierKeyword.FINAL_KEYWORD);
        Block body = ast.newBlock();
        md.setBody(body);
        ReturnStatement ret = ast.newReturnStatement();
        body.statements().add(ret);
        MethodInvocation cast = ast.newMethodInvocation();
        cast.setName(ast.newSimpleName("cast"));
        cast.setExpression((Expression)ast.newSimpleName("clazz"));
        ret.setExpression((Expression)cast);
        ClassInstanceCreation newImpl = ast.newClassInstanceCreation();
        newImpl.setType((Type)ast.newSimpleType(ast.newName(td.getName().getIdentifier())));
        cast.arguments().add(newImpl);
        newImpl.arguments().add(ast.newSimpleName("connection"));
        newImpl.arguments().add(ast.newSimpleName("varlink"));
    }

    private static final Stream<Error> errors(Interface iface) {
        return iface.getMembers().stream().filter(m -> m instanceof Error).map(m -> (Error)m);
    }

    private static final Stream<Method> methods(Interface iface) {
        return iface.getMembers().stream().filter(m -> m instanceof Method).map(m -> (Method)m);
    }

    private static final Stream<TypeAlias> types(Interface iface) {
        return iface.getMembers().stream().filter(m -> m instanceof TypeAlias).map(m -> (TypeAlias)m);
    }

    private static final Stream<MethodInformation> map(Interface iface, AST ast, Stream<Method> stream) {
        return stream.map(m -> JdtGenerator.map(ast, iface, m));
    }

    private static final void forMethods(AST ast, Interface iface, BiConsumer<MethodInformation, MethodDeclaration> consumer) {
        JdtGenerator.map(iface, ast, JdtGenerator.methods(iface)).forEach(m -> {
            MethodDeclaration md = ast.newMethodDeclaration();
            md.setName(ast.newSimpleName(m.getName()));
            md.setReturnType2(m.createMainReturnType(ast));
            for (Map.Entry<String, Type> parameter : m.getParameters().entrySet()) {
                SingleVariableDeclaration par = ast.newSingleVariableDeclaration();
                par.setName(ast.newSimpleName(parameter.getKey()));
                par.setType((Type)JdtHelper.copyNode(ast, (ASTNode)parameter.getValue()));
                JdtHelper.make(par, Modifier.ModifierKeyword.FINAL_KEYWORD);
                md.parameters().add(par);
            }
            consumer.accept((MethodInformation)m, md);
        });
    }

    private static MethodInformation map(AST ast, Interface iface, Method method) {
        Object result;
        String name = Names.toLowerFirst(method.getName());
        LinkedHashMap<String, Type> parameters = new LinkedHashMap<String, Type>();
        LinkedHashMap<String, Type> returns = new LinkedHashMap<String, Type>();
        Object arguments = method.getArguments().getArguments();
        if (arguments != null) {
            for (Field field : arguments.getFields()) {
                Type type = JdtGenerator.asType(ast, JdtGenerator.methodArgumentsParentName(method), field);
                parameters.put(field.getName(), type);
            }
        }
        if ((result = method.getResult().getResult()) != null) {
            for (Field field : result.getFields()) {
                Type type = JdtGenerator.asType(ast, JdtGenerator.methodResultParentName(method), field);
                returns.put(field.getName(), type);
            }
        }
        return new MethodInformation(iface, method, name, returns, parameters);
    }

    private void createInterface(AST ast, CompilationUnit cu, Interface iface, String name) {
        TypeDeclaration td = ast.newTypeDeclaration();
        cu.types().add(td);
        td.setInterface(true);
        td.setName(ast.newSimpleName(name));
        JdtHelper.make((BodyDeclaration)td, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        NormalAnnotation ann = JdtHelper.addAnnotation((BodyDeclaration)td, "de.dentrassi.varlink.spi.Interface");
        MemberValuePair mvpName = ast.newMemberValuePair();
        ann.values().add(mvpName);
        mvpName.setName(ast.newSimpleName("name"));
        mvpName.setValue((Expression)JdtHelper.newStringLiteral(ast, iface.getName()));
        MemberValuePair mvpFactory = ast.newMemberValuePair();
        ann.values().add(mvpFactory);
        mvpFactory.setName(ast.newSimpleName("factory"));
        TypeLiteral fn = ast.newTypeLiteral();
        fn.setType((Type)ast.newSimpleType(ast.newName(name + "Impl.Factory")));
        mvpFactory.setValue((Expression)fn);
        this.createTypes(td, iface);
        this.createErrors(td, iface);
        TypeDeclaration async = ast.newTypeDeclaration();
        td.bodyDeclarations().add(async);
        async.setInterface(true);
        JdtHelper.make((BodyDeclaration)async, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        async.setName(ast.newSimpleName("Async"));
        JdtGenerator.forMethods(ast, iface, (m, md) -> {
            JdtHelper.make((BodyDeclaration)md, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            async.bodyDeclarations().add(md);
            this.makeAsync((MethodDeclaration)md);
        });
        MethodDeclaration md2 = ast.newMethodDeclaration();
        td.bodyDeclarations().add(md2);
        md2.setName(ast.newSimpleName("async"));
        JdtHelper.make((BodyDeclaration)md2, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        SimpleType rt = ast.newSimpleType((Name)ast.newSimpleName("Async"));
        md2.setReturnType2((Type)rt);
        TypeDeclaration sync = ast.newTypeDeclaration();
        td.bodyDeclarations().add(sync);
        sync.setInterface(true);
        JdtHelper.make((BodyDeclaration)sync, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        sync.setName(ast.newSimpleName("Sync"));
        JdtGenerator.forMethods(ast, iface, (m, md) -> {
            JdtHelper.make((BodyDeclaration)md, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            sync.bodyDeclarations().add(md);
        });
        MethodDeclaration smd = ast.newMethodDeclaration();
        smd.setName(ast.newSimpleName("sync"));
        JdtHelper.make((BodyDeclaration)smd, Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.DEFAULT_KEYWORD);
        td.bodyDeclarations().add(smd);
        Block body = ast.newBlock();
        smd.setBody(body);
        ReturnStatement ret = ast.newReturnStatement();
        body.statements().add(ret);
        ClassInstanceCreation cic = ast.newClassInstanceCreation();
        cic.setType((Type)ast.newSimpleType(ast.newName("Sync")));
        ret.setExpression((Expression)cic);
        smd.setReturnType2((Type)ast.newSimpleType(ast.newName("Sync")));
        AnonymousClassDeclaration acc = ast.newAnonymousClassDeclaration();
        cic.setAnonymousClassDeclaration(acc);
        JdtGenerator.forMethods(ast, iface, (m, md) -> {
            JdtHelper.make((BodyDeclaration)md, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            acc.bodyDeclarations().add(md);
            Block mbody = ast.newBlock();
            md.setBody(mbody);
            MethodInvocation await = ast.newMethodInvocation();
            await.setExpression((Expression)ast.newName("de.dentrassi.varlink.spi.Syncer"));
            await.setName(ast.newSimpleName("await"));
            MethodInvocation asyncCall = ast.newMethodInvocation();
            asyncCall.setName(ast.newSimpleName("async"));
            MethodInvocation mcall = ast.newMethodInvocation();
            mcall.setName(ast.newSimpleName(m.getName()));
            mcall.setExpression((Expression)asyncCall);
            await.arguments().add(mcall);
            for (String argName : m.getParameters().keySet()) {
                mcall.arguments().add(ast.newSimpleName(argName));
            }
            if (m.getReturnTypes().isEmpty()) {
                mbody.statements().add(ast.newExpressionStatement((Expression)await));
            } else {
                ReturnStatement rs = ast.newReturnStatement();
                rs.setExpression((Expression)await);
                mbody.statements().add(rs);
            }
        });
    }

    private static String methodArgumentsParentName(Method method) {
        return method.getName() + "_In";
    }

    private static String methodResultParentName(Method method) {
        return method.getName() + "_Out";
    }

    private void createErrors(TypeDeclaration td, Interface iface) {
        AST ast = td.getAST();
        JdtGenerator.errors(iface).forEach(error -> this.createError(td, ast, (Error)error));
    }

    private void createError(TypeDeclaration td, AST ast, Error error) {
        TypeDeclaration etd = ast.newTypeDeclaration();
        td.bodyDeclarations().add(etd);
        etd.setName(ast.newSimpleName(this.errorTypeName(error)));
        JdtHelper.make((BodyDeclaration)etd, Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
        etd.setSuperclassType((Type)ast.newSimpleType(ast.newName("java.lang.RuntimeException")));
        JdtGenerator.createSerialId(ast, etd.bodyDeclarations());
        this.createType(etd, "Parameters", (TypeAliasDefinition)error.getProperties());
        VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
        vdf.setName(ast.newSimpleName("parameters"));
        FieldDeclaration fd = ast.newFieldDeclaration(vdf);
        fd.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("Parameters")));
        JdtHelper.make((BodyDeclaration)fd, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        etd.bodyDeclarations().add(fd);
        MethodDeclaration ctor = ast.newMethodDeclaration();
        ctor.setConstructor(true);
        ctor.setName(ast.newSimpleName(this.errorTypeName(error)));
        JdtHelper.make((BodyDeclaration)ctor, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        etd.bodyDeclarations().add(ctor);
        JdtHelper.createParameter(ctor, "Parameters", "parameters", Modifier.ModifierKeyword.FINAL_KEYWORD);
        Block body = ast.newBlock();
        ctor.setBody(body);
        JdtHelper.createThisAssignment(body, "parameters");
        MethodDeclaration getter = JdtHelper.createGetter(ast, (Type)ast.newSimpleType((Name)ast.newSimpleName("Parameters")), "parameters");
        etd.bodyDeclarations().add(getter);
    }

    private static void createSerialId(AST ast, List body) {
        VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
        vdf.setInitializer((Expression)ast.newNumberLiteral("1L"));
        vdf.setName(ast.newSimpleName("serialVersionUID"));
        FieldDeclaration fd = ast.newFieldDeclaration(vdf);
        fd.setType((Type)ast.newPrimitiveType(PrimitiveType.LONG));
        JdtHelper.make((BodyDeclaration)fd, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        body.add(fd);
    }

    private void createTypes(TypeDeclaration td, Interface iface) {
        JdtGenerator.types(iface).forEach(type -> this.createType(td, type.getName(), type.getDefinition()));
        JdtGenerator.methods(iface).forEach(method -> {
            for (Field field : method.getArguments().getArguments().getFields()) {
                this.methodCreateTopLevelType(td, JdtGenerator.methodArgumentsParentName(method) + "_" + field.getName(), field.getType());
            }
            if (method.getResult().getResult().getFields().size() <= 1) {
                for (Field field : method.getResult().getResult().getFields()) {
                    this.methodCreateTopLevelType(td, JdtGenerator.methodResultParentName(method) + "_" + field.getName(), field.getType());
                }
            } else {
                this.createType(td, JdtGenerator.methodResultParentName(method), (TypeAliasDefinition)method.getResult().getResult());
            }
        });
    }

    private void methodCreateTopLevelType(TypeDeclaration td, String parentName, ElementType type) {
        if (type instanceof Object || type instanceof Enum) {
            this.createType(td, parentName, (TypeAliasDefinition)((Object)type));
        } else if (type instanceof Array) {
            this.methodCreateTopLevelType(td, parentName, ((Array)type).getType());
        } else if (type instanceof Dictionary) {
            this.methodCreateTopLevelType(td, parentName, ((Dictionary)type).getType());
        } else if (type instanceof Optional) {
            this.methodCreateTopLevelType(td, parentName, ((Optional)type).getType());
        }
    }

    private void createType(TypeDeclaration parent, String parentName, TypeAliasDefinition type) {
        AST ast = parent.getAST();
        if (type instanceof Object) {
            TypeDeclaration td = ast.newTypeDeclaration();
            parent.bodyDeclarations().add(td);
            td.setName(ast.newSimpleName(Names.toUpperFirst(parentName)));
            JdtHelper.make((BodyDeclaration)td, Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
            Object o = (Object)type;
            for (Field field : o.getFields()) {
                String name = Names.toLowerFirst(field.getName());
                if (field.getType() instanceof Enum) {
                    Enum en = (Enum)field.getType();
                    this.createEnum(td, Names.toUpperFirst(name), (EList<String>)en.getFields());
                }
                if (field.getType() instanceof Object) {
                    this.createType(td, field.getName(), (TypeAliasDefinition)((Object)field.getType()));
                }
                VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
                vdf.setName(ast.newSimpleName(name));
                FieldDeclaration fd = ast.newFieldDeclaration(vdf);
                fd.setType(JdtGenerator.asType(ast, null, field));
                JdtHelper.make((BodyDeclaration)fd, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                td.bodyDeclarations().add(fd);
                MethodDeclaration md = JdtHelper.createGetter(ast, JdtGenerator.asType(ast, null, field), name);
                td.bodyDeclarations().add(md);
                md = ast.newMethodDeclaration();
                md.setName(ast.newSimpleName("set" + Names.toUpperFirst(name)));
                td.bodyDeclarations().add(md);
                JdtHelper.make((BodyDeclaration)md, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                SingleVariableDeclaration svd = ast.newSingleVariableDeclaration();
                svd.setName(ast.newSimpleName(name));
                svd.setType(JdtGenerator.asType(ast, null, field));
                md.parameters().add(svd);
                Block body = ast.newBlock();
                md.setBody(body);
                FieldAccess fa = ast.newFieldAccess();
                fa.setExpression((Expression)ast.newThisExpression());
                fa.setName(ast.newSimpleName(name));
                Assignment ass = ast.newAssignment();
                ass.setLeftHandSide((Expression)fa);
                ass.setRightHandSide((Expression)ast.newSimpleName(name));
                body.statements().add(ast.newExpressionStatement((Expression)ass));
            }
        } else if (type instanceof Enum) {
            // empty if block
        }
    }

    private void createEnum(TypeDeclaration td, String name, EList<String> literals) {
        AST ast = td.getAST();
        EnumDeclaration ed = ast.newEnumDeclaration();
        td.bodyDeclarations().add(ed);
        ed.setName(ast.newSimpleName(name));
        JdtHelper.make((BodyDeclaration)ed, Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
        for (String literal : literals) {
            EnumConstantDeclaration ecd = ast.newEnumConstantDeclaration();
            ecd.setName(ast.newSimpleName(literal));
            ed.enumConstants().add(ecd);
        }
    }

    private static Type asType(AST ast, String parentName, Field field) {
        parentName = parentName != null ? parentName + "_" + field.getName() : field.getName();
        return JdtGenerator.asType(ast, parentName, field.getType());
    }

    private static Type asType(AST ast, String parentName, ElementType type) {
        if (type instanceof BasicType) {
            return JdtGenerator.fromBasicType(ast, type);
        }
        if (type instanceof Array) {
            Type baseType = JdtGenerator.asType(ast, parentName, ((Array)type).getType());
            ParameterizedType result = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName("java.util.List")));
            result.typeArguments().add(baseType);
            return result;
        }
        if (type instanceof Optional) {
            Type baseType = JdtGenerator.asType(ast, parentName, ((Optional)type).getType());
            ParameterizedType result = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName("java.util.Optional")));
            result.typeArguments().add(baseType);
            return result;
        }
        if (type instanceof Dictionary) {
            Type baseType = JdtGenerator.asType(ast, parentName, ((Dictionary)type).getType());
            ParameterizedType result = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName("java.util.Map")));
            result.typeArguments().add(ast.newSimpleType(ast.newName("java.lang.String")));
            result.typeArguments().add(baseType);
            return result;
        }
        if (type instanceof Enum || type instanceof Object) {
            return ast.newSimpleType((Name)ast.newSimpleName(Names.toUpperFirst(parentName)));
        }
        if (type instanceof TypeReference) {
            String name = ((TypeReference)type).getName().getName();
            return ast.newSimpleType((Name)ast.newSimpleName(Names.toUpperFirst(name)));
        }
        throw new IllegalArgumentException("Unsupported type: " + type.eClass().getName());
    }

    private static Type fromBasicType(AST ast, ElementType type) {
        switch (((BasicType)type).getType().toLowerCase()) {
            case "float": {
                return ast.newSimpleType(ast.newName("java.lang.Double"));
            }
            case "int": {
                return ast.newSimpleType(ast.newName("java.lang.Long"));
            }
            case "bool": {
                return ast.newSimpleType(ast.newName("java.lang.Boolean"));
            }
            case "string": {
                return ast.newSimpleType(ast.newName("java.lang.String"));
            }
        }
        throw new IllegalArgumentException("Unknown basic type: " + ((BasicType)type).getType().toLowerCase());
    }

    private void makeAsync(MethodDeclaration md) {
        AST ast = md.getAST();
        Type ret = md.getReturnType2();
        ParameterizedType future = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName("java.util.concurrent.CompletableFuture")));
        if (ret instanceof PrimitiveType) {
            if (((PrimitiveType)ret).getPrimitiveTypeCode() == PrimitiveType.VOID) {
                future.typeArguments().add(ast.newSimpleType(ast.newName("java.lang.Void")));
            }
        } else {
            md.setReturnType2(null);
            future.typeArguments().add(ret);
        }
        md.setReturnType2((Type)future);
    }

    private static class MethodInformation {
        private final Interface iface;
        private final String name;
        private final Method method;
        private final Map<String, Type> returnTypes;
        private final Map<String, Type> parameters;

        public MethodInformation(Interface iface, Method method, String name, Map<String, Type> returnTypes, Map<String, Type> parameters) {
            this.iface = iface;
            this.method = method;
            this.name = name;
            this.returnTypes = returnTypes;
            this.parameters = parameters;
        }

        public Interface getInterface() {
            return this.iface;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Type> getParameters() {
            return this.parameters;
        }

        public Map<String, Type> getReturnTypes() {
            return this.returnTypes;
        }

        public Type createMainReturnType(AST ast) {
            if (this.returnTypes.isEmpty()) {
                return ast.newPrimitiveType(PrimitiveType.VOID);
            }
            if (this.returnTypes.size() == 1) {
                return (Type)JdtHelper.copyNode(ast, (ASTNode)this.returnTypes.values().iterator().next());
            }
            return ast.newSimpleType((Name)ast.newSimpleName(JdtGenerator.methodResultParentName(this.method)));
        }
    }
}

