/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.varlink.generator;

import de.dentrassi.varlink.idl.varlinkIdl.Interface;
import de.dentrassi.varlink.maven.Loader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public interface Generator {
    public void generate(Interface var1);

    default public void generateAll(Collection<Interface> interfaces) {
        interfaces.stream().forEach(this::generate);
    }

    default public void generateAll(Loader loader) {
        this.generateAll(loader.getInterfaces());
    }

    public static final class Options {
        private Path targetPath;
        private Charset characterSet = StandardCharsets.UTF_8;

        public Options() {
        }

        public Options(Options other) {
            this.targetPath = other.targetPath;
            this.characterSet = other.characterSet;
        }

        public void setCharacterSet(Charset characterSet) {
            this.characterSet = characterSet != null ? characterSet : StandardCharsets.UTF_8;
        }

        public Charset getCharacterSet() {
            return this.characterSet;
        }

        public void setTargetPath(Path targetPath) {
            this.targetPath = targetPath;
        }

        public Path getTargetPath() {
            return this.targetPath;
        }

        public void validate(List<Exception> errors) {
            if (this.targetPath == null) {
                errors.add(new IllegalStateException("'targetPath' is not set"));
            }
        }

        public void validate() {
            LinkedList<Exception> errors = new LinkedList<Exception>();
            this.validate(errors);
            if (!errors.isEmpty()) {
                RuntimeException e = new RuntimeException("Invalid generator settings", errors.pollFirst());
                errors.stream().forEach(e::addSuppressed);
                throw e;
            }
        }
    }
}

