/*
 * Decompiled with CFR 0.152.
 */
package io.systemd;

import com.google.gson.JsonElement;
import de.dentrassi.varlink.internal.VarlinkImpl;
import de.dentrassi.varlink.spi.CallRequest;
import de.dentrassi.varlink.spi.CallResponse;
import de.dentrassi.varlink.spi.Connection;
import de.dentrassi.varlink.spi.Errors;
import io.systemd.Network;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NetworkImpl
implements Network {
    private final Connection connection;
    private final VarlinkImpl varlink;

    private NetworkImpl(VarlinkImpl varlink, Connection connection) {
        this.varlink = varlink;
        this.connection = connection;
    }

    @Override
    public Network.Async async() {
        return new Network.Async(){

            @Override
            public CompletableFuture<List<Network.Netdev>> list() {
                return NetworkImpl.this.executeList();
            }
        };
    }

    protected CompletableFuture<List<Network.Netdev>> executeList() {
        return this.connection.call(CallRequest.of((String)"io.systemd.network.List")).thenApply(cr -> {
            Errors.check((CallResponse)cr);
            Iterator i = cr.getParameters().values().iterator();
            return Arrays.asList((Object[])this.varlink.fromJson(Network.Netdev[].class, (JsonElement)i.next()));
        });
    }

    public static class Factory
    implements de.dentrassi.varlink.spi.Factory {
        public <T> T create(VarlinkImpl varlink, Class<T> clazz, Connection connection) {
            return clazz.cast(new NetworkImpl(varlink, connection));
        }
    }
}

