/*
 * Decompiled with CFR 0.152.
 */
package io.systemd;

import de.dentrassi.varlink.spi.Interface;
import de.dentrassi.varlink.spi.Syncer;
import io.systemd.NetworkImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@Interface(factory=NetworkImpl.Factory.class)
public interface Network {
    public Async async();

    default public Sync sync() {
        return new Sync(){

            @Override
            public List<Netdev> list() {
                return (List)Syncer.await(Network.this.async().list());
            }
        };
    }

    public static interface Sync {
        public List<Netdev> list();
    }

    public static interface Async {
        public CompletableFuture<List<Netdev>> list();
    }

    public static class Netdev {
        private int ifindex;
        private String ifname;

        public int getIfindex() {
            return this.ifindex;
        }

        public void setIfindex(int ifindex) {
            this.ifindex = ifindex;
        }

        public String getIfname() {
            return this.ifname;
        }

        public void setIfname(String ifname) {
            this.ifname = ifname;
        }
    }
}

