/*
 * Decompiled with CFR 0.152.
 */
package io.systemd.network;

import de.dentrassi.varlink.internal.VarlinkImpl;
import de.dentrassi.varlink.spi.CallRequest;
import de.dentrassi.varlink.spi.CallResponse;
import de.dentrassi.varlink.spi.Connection;
import de.dentrassi.varlink.spi.Errors;
import io.systemd.network.Network;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NetworkImpl
implements Network {
    private final Connection connection;
    private final VarlinkImpl varlink;

    private NetworkImpl(VarlinkImpl varlink, Connection connection) {
        this.varlink = varlink;
        this.connection = connection;
    }

    @Override
    public Network.Async async() {
        return new Network.Async(){

            @Override
            public CompletableFuture<List<Network.Netdev>> list() {
                return NetworkImpl.this.executeList();
            }
        };
    }

    protected CompletableFuture<List<Network.Netdev>> executeList() {
        return this.connection.call(CallRequest.of((String)"io.systemd.network.List")).thenApply(cr -> {
            Errors.check((CallResponse)cr);
            return Arrays.asList((Object[])this.varlink.fromJson(Network.Netdev[].class, cr.getFirstParameter()));
        });
    }

    public static class Factory
    implements de.dentrassi.varlink.spi.Factory {
        public <T> T create(VarlinkImpl varlink, Class<T> clazz, Connection connection) {
            return clazz.cast(new NetworkImpl(varlink, connection));
        }
    }
}

