/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Script {
    private String interpreter;
    private File file;
    private String script;

    public String getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(String interpreter) {
        this.interpreter = interpreter;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void set(String script) {
        this.setScript(script);
    }

    public String makeScriptContent() throws IOException {
        if (this.file != null && !Strings.isNullOrEmpty((String)this.script)) {
            throw new IllegalStateException("Script must not have 'file' and 'script' set at the same time.");
        }
        if (this.file != null) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8);){
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
        }
        return this.script;
    }
}

