/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.packager.rpm.RpmBaseTag;
import org.eclipse.packager.rpm.RpmTag;
import org.eclipse.packager.rpm.parse.HeaderValue;
import org.eclipse.packager.rpm.parse.InputHeader;
import org.eclipse.packager.rpm.parse.RpmInputStream;

@Mojo(name="unpack", requiresProject=false, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=false)
public final class RpmUnpackMojo
extends AbstractMojo {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_FILENAME_LENGTH = 256;
    private static final Pattern FILENAME_PATTERN = Pattern.compile("^[\\p{Print}&&[^\\\\:*?\"<>|]]+$");
    private Logger logger;
    @Parameter(property="rpm.file", required=true)
    private File rpmFile;
    @Parameter(property="rpm.unpackDirectory", defaultValue="${project.build.directory}/rpm/unpack")
    private File unpackDirectory;
    @Parameter(property="rpm.preserveLastModificationTime", defaultValue="true")
    private boolean preserveLastModificationTime;
    @Parameter(property="rpm.preserveOwner", defaultValue="false")
    private boolean preserveOwner;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logger = new Logger(this.getLog());
        Path targetDir = this.unpackDirectory.toPath();
        if (!Files.exists(targetDir, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                this.logger.debug("Unable to create unpack directory %s", targetDir);
                throw new MojoExecutionException("RPM unpack failed", (Exception)e);
            }
        }
        try (RpmInputStream in = new RpmInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.rpmFile)));){
            CpioArchiveEntry entry;
            InputHeader header = in.getPayloadHeader();
            header.getEntry((RpmBaseTag)RpmTag.FILE_GROUPNAME);
            header.getEntry((RpmBaseTag)RpmTag.FILE_USERNAME);
            CpioArchiveInputStream cpio = in.getCpioStream();
            while ((entry = cpio.getNextCPIOEntry()) != null) {
                this.unpackEntry((InputHeader<RpmTag>)header, (InputStream)cpio, entry, targetDir);
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.logger.warn("Bad or insecure RPM file %s", this.rpmFile);
            throw new MojoFailureException("RPM unpack failed, due to bad or insecure RPM file", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.debug("Unable to unpack RPM file %s", this.rpmFile);
            throw new MojoFailureException("RPM unpack failed, due to I/O error", (Throwable)e);
        }
    }

    private void unpackEntry(InputHeader<RpmTag> payloadHeader, InputStream in, CpioArchiveEntry entry, Path targetDir) throws IOException {
        if (entry.isDirectory()) {
            Path directory = this.makeTargetFile(targetDir, entry.getName());
            if (!Files.exists(directory, new LinkOption[0])) {
                this.logger.debug("Creating directory %s as %s", entry.getName(), directory);
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            this.applyFileAttributes(payloadHeader, directory, entry);
        } else if (entry.isRegularFile()) {
            Path file = this.makeTargetFile(targetDir, entry.getName());
            this.logger.debug("Unpacking file %s to %s", entry.getName(), file);
            Files.deleteIfExists(file);
            Path directory = file.getParent();
            if (directory != null && !Files.exists(directory, new LinkOption[0])) {
                this.logger.debug("Creating parent directories: %s", directory);
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                int n;
                byte[] buf = new byte[8192];
                for (long remaining = entry.getSize(); remaining > 0L && (n = in.read(buf, 0, RpmUnpackMojo.getReadSize(remaining, buf.length))) > 0; remaining -= (long)n) {
                    os.write(buf, 0, n);
                }
            }
            this.applyFileAttributes(payloadHeader, file, entry);
        } else if (entry.isSymbolicLink()) {
            String linkTo = RpmUnpackMojo.getLinkTarget(payloadHeader, entry.getInode());
            this.logger.debug("Ignoring symbolic link %s -> %s", entry.getName(), linkTo);
        } else {
            this.logger.debug("Ignoring entry %s, as it is not a directory, file or symbolic link", entry.getName());
        }
    }

    private static int getReadSize(long size, int bufferSize) {
        return size > (long)bufferSize ? bufferSize : (int)size;
    }

    private Path makeTargetFile(Path parent, String fileName) {
        this.logger.debug("Checking filename: %s", fileName);
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("File name is null or empty");
        }
        if (fileName.length() > 256) {
            throw new IllegalArgumentException(" RPM contains file name that exceeds 256, starting with: " + fileName.substring(0, 256));
        }
        if (fileName.contains("../")) {
            throw new IllegalArgumentException("RPM contain relative path: " + fileName);
        }
        if (!FILENAME_PATTERN.matcher(fileName).matches()) {
            throw new IllegalArgumentException("RPM contains bad characters in file name: " + fileName);
        }
        return parent.resolve(fileName).normalize();
    }

    private void applyFileAttributes(InputHeader<RpmTag> payloadHeader, Path path, CpioArchiveEntry entry) {
        if (this.preserveLastModificationTime) {
            try {
                Files.setLastModifiedTime(path, FileTime.from(entry.getLastModifiedDate().toInstant()));
            }
            catch (IOException e) {
                this.logger.debug("Could not preserve last-modification time for %s, due to I/O error: %s", path, e.getMessage());
            }
        }
        this.setFilePermissions(path, entry);
        if (this.preserveOwner) {
            this.setFileOwnership(payloadHeader, path, entry);
        }
    }

    private void setFilePermissions(Path path, CpioArchiveEntry entry) {
        BasicFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        if (view == null) {
            view = Files.getFileAttributeView(path, DosFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        }
        if (view instanceof PosixFileAttributeView) {
            try {
                view.setPermissions(RpmUnpackMojo.fromMode(entry.getMode()));
            }
            catch (IOException e) {
                this.logger.debug("Could not set POSIX file attributes on %s, due to I/O error: %s", path, e.getMessage());
            }
        } else if (view instanceof DosFileAttributeView) {
            this.logger.debug("DOS-compatible File System - permission will be limited to read/write", new Object[0]);
            try {
                ((DosFileAttributeView)view).setReadOnly((entry.getMode() & 0x80L) == 0L);
            }
            catch (IOException e) {
                this.logger.debug("Could not set DOS read/write attributes on %s, due to I/O error: %s", path, e.getMessage());
            }
        } else {
            this.logger.debug("FS does not support POSIX or DOS attributes - using default permissions for %s", path);
        }
    }

    private static Set<PosixFilePermission> fromMode(long mode) {
        EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100L) != 0L) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80L) != 0L) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40L) != 0L) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20L) != 0L) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10L) != 0L) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8L) != 0L) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4L) != 0L) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2L) != 0L) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1L) != 0L) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    private void setFileOwnership(InputHeader<RpmTag> payloadHeader, Path path, CpioArchiveEntry entry) {
        UserPrincipal user;
        UserPrincipalLookupService service;
        FileOwnerAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        if (view == null) {
            view = Files.getFileAttributeView(path, FileOwnerAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        }
        if (view == null) {
            this.logger.debug("File System does not support ownership", new Object[0]);
            return;
        }
        String userName = RpmUnpackMojo.getName(payloadHeader, RpmTag.FILE_USERNAME, entry.getUID());
        try {
            service = path.getFileSystem().getUserPrincipalLookupService();
            user = service.lookupPrincipalByName(userName);
        }
        catch (UnsupportedOperationException e) {
            this.logger.debug("Principal Lookup Service not supported: %s", e.getMessage());
            return;
        }
        catch (UserPrincipalNotFoundException e) {
            this.logger.debug("User (%s) do not exist - unable to preserve ownership", userName);
            return;
        }
        catch (IOException e) {
            this.logger.debug("Could not lookup user (%s) due to I/O error: %s", userName, e.getMessage());
            return;
        }
        if (view instanceof PosixFileAttributeView) {
            String groupName = RpmUnpackMojo.getName(payloadHeader, RpmTag.FILE_GROUPNAME, entry.getGID());
            try {
                ((PosixFileAttributeView)view).setGroup(service.lookupPrincipalByGroupName(groupName));
            }
            catch (UserPrincipalNotFoundException e) {
                this.logger.debug("Group (%s) do not exist - unable to preserve group ownership", groupName);
            }
            catch (IOException e) {
                this.logger.debug("Could not apply group (%s) due to I/O error: %s", groupName, e.getMessage());
            }
        }
        try {
            view.setOwner(user);
        }
        catch (IOException e) {
            this.logger.debug("Could not apply user (%s) due to I/O error: %s", userName, e.getMessage());
        }
    }

    private static String getName(InputHeader<RpmTag> payloadHeader, RpmTag tag, long id) {
        Object values = ((HeaderValue)payloadHeader.getEntry((RpmBaseTag)tag).orElseThrow(() -> new IllegalStateException("RPM lacks " + tag + " lookup table"))).getValue();
        if (!(values instanceof String[])) {
            throw new IllegalStateException("RPM " + tag + " header is not a list of Strings, got " + values.getClass());
        }
        String[] names = (String[])values;
        if (id < 0L || (long)names.length <= id) {
            throw new IllegalArgumentException("id out of range [0," + names.length + ']');
        }
        return names[(int)id];
    }

    private static String getLinkTarget(InputHeader<RpmTag> payloadHeader, long inode) {
        Object values = ((HeaderValue)payloadHeader.getEntry((RpmBaseTag)RpmTag.FILE_LINKTO).orElseThrow(() -> new IllegalStateException("RPM contains symbolic link, but lacks linkTo header"))).getValue();
        if (!(values instanceof String[])) {
            throw new IllegalStateException("RPM linkTo header is not a list of Strings, got " + values.getClass());
        }
        String[] linkTo = (String[])values;
        if (inode < 0L || (long)linkTo.length <= inode) {
            throw new IllegalArgumentException("Symbolic link inode out of range [0," + linkTo.length + ']');
        }
        return linkTo[(int)inode];
    }

    public void setRpmFile(File rpmFile) {
        this.rpmFile = rpmFile;
    }

    public void setUnpackDirectory(File unpackDirectory) {
        this.unpackDirectory = unpackDirectory;
    }

    public void setPreserveLastModificationTime(boolean preserveLastModificationTime) {
        this.preserveLastModificationTime = preserveLastModificationTime;
    }

    public void setPreserveOwner(boolean preserveOwner) {
        this.preserveOwner = preserveOwner;
    }
}

