/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.BuilderContextListener;
import de.dentrassi.rpm.builder.MojoFileInformationProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.packager.rpm.build.BuilderContext;
import org.eclipse.packager.rpm.build.FileInformationProvider;

public class MissingDirectoryTracker
implements BuilderContextListener {
    private final Set<String> explicitAddedDirectories = new HashSet<String>();
    private final Map<String, FileInformationProvider<Object>> missingDirectories = new HashMap<String, FileInformationProvider<Object>>();
    private final List<String> baseDirectories;

    public MissingDirectoryTracker(List<String> baseDirectories) {
        this.baseDirectories = baseDirectories;
    }

    @Override
    public void notifyFileAdded(String targetName, FileInformationProvider<Object> provider) {
        this.addMissingDirectoriesFromPath(targetName, provider);
    }

    @Override
    public void notifyDirectoryAdded(String targetName, FileInformationProvider<Object> provider) {
        this.explicitAddedDirectories.add(targetName);
        this.missingDirectories.remove(targetName);
        this.addMissingDirectoriesFromPath(targetName, provider);
    }

    @Override
    public void notifySymbolicLinkAdded(String targetName, FileInformationProvider<Object> provider) {
        this.addMissingDirectoriesFromPath(targetName, provider);
    }

    private void addMissingDirectoriesFromPath(String targetName, FileInformationProvider<Object> provider) {
        if (provider instanceof MojoFileInformationProvider) {
            List<String> intermediateDirectories;
            MojoFileInformationProvider mojoProvider = (MojoFileInformationProvider)provider;
            if (this.containsCollectEntry(mojoProvider)) {
                targetName = mojoProvider.getEntry().getName();
                intermediateDirectories = this.getIntermediateDirectoriesIncludingTarget(targetName);
            } else {
                intermediateDirectories = this.getIntermediateDirectories(targetName);
            }
            for (String intermediateDirectory : intermediateDirectories) {
                this.addIfIsMissingDirectory(intermediateDirectory, mojoProvider);
            }
        }
    }

    private void addIfIsMissingDirectory(String intermediateDirectory, MojoFileInformationProvider mojoProvider) {
        if (this.startsPathWithPrefix(intermediateDirectory) && !this.explicitAddedDirectories.contains(intermediateDirectory)) {
            this.missingDirectories.computeIfAbsent(intermediateDirectory, directory -> new MojoFileInformationProvider(mojoProvider.getRulesetEval(), mojoProvider.getRuleId(), null, mojoProvider.getLogger(), mojoProvider.getTimestamp()));
        }
    }

    private boolean containsCollectEntry(MojoFileInformationProvider mojoProvider) {
        return mojoProvider.getEntry().getCollect() != null;
    }

    private boolean startsPathWithPrefix(String directory) {
        return this.baseDirectories.stream().anyMatch(directory::startsWith);
    }

    public void addMissingIntermediateDirectoriesToContext(BuilderContext ctx) throws IOException {
        for (Map.Entry<String, FileInformationProvider<Object>> missingEntry : this.missingDirectories.entrySet()) {
            ctx.addDirectory(missingEntry.getKey(), missingEntry.getValue());
        }
    }

    private List<String> getIntermediateDirectories(String targetName) {
        ArrayList<String> intermediateDirectories = new ArrayList<String>();
        Path path = Paths.get(targetName, new String[0]);
        for (int i = 1; i < path.getNameCount(); ++i) {
            Path subPath = path.subpath(0, i);
            intermediateDirectories.add("/" + subPath);
        }
        return intermediateDirectories;
    }

    private List<String> getIntermediateDirectoriesIncludingTarget(String targetName) {
        List<String> intermediateDirectories = this.getIntermediateDirectories(targetName);
        intermediateDirectories.add(targetName);
        return intermediateDirectories;
    }
}

