/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.BuilderContextListener;
import de.dentrassi.rpm.builder.MojoFileInformationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.packager.rpm.build.BuilderContext;
import org.eclipse.packager.rpm.build.FileInformationProvider;

public class ListenableBuilderContext
implements BuilderContext {
    private final BuilderContext builderContext;
    private final Set<BuilderContextListener> listeners;

    public ListenableBuilderContext(BuilderContext builderContext) {
        this.builderContext = builderContext;
        this.listeners = new HashSet<BuilderContextListener>();
    }

    public void setDefaultInformationProvider(FileInformationProvider<Object> provider) {
        this.builderContext.setDefaultInformationProvider(provider);
    }

    public FileInformationProvider<Object> getDefaultInformationProvider() {
        return this.builderContext.getDefaultInformationProvider();
    }

    public void addFile(String targetName, Path source, FileInformationProvider<? super Path> provider) throws IOException {
        this.builderContext.addFile(targetName, source, provider);
        this.listeners.forEach(listener -> listener.notifyFileAdded(targetName, (MojoFileInformationProvider)provider));
    }

    public void addFile(String targetName, InputStream source, FileInformationProvider<Object> provider) throws IOException {
        this.builderContext.addFile(targetName, source, provider);
        this.listeners.forEach(listener -> listener.notifyFileAdded(targetName, provider));
    }

    public void addFile(String targetName, ByteBuffer source, FileInformationProvider<Object> provider) throws IOException {
        this.builderContext.addFile(targetName, source, provider);
        this.listeners.forEach(listener -> listener.notifyFileAdded(targetName, provider));
    }

    public void addDirectory(String targetName, FileInformationProvider<? super BuilderContext.Directory> provider) throws IOException {
        this.builderContext.addDirectory(targetName, provider);
        this.listeners.forEach(listener -> listener.notifyDirectoryAdded(targetName, (MojoFileInformationProvider)provider));
    }

    public void addSymbolicLink(String targetName, String linkTo, FileInformationProvider<? super BuilderContext.SymbolicLink> provider) throws IOException {
        this.builderContext.addSymbolicLink(targetName, linkTo, provider);
        this.listeners.forEach(listener -> listener.notifySymbolicLinkAdded(targetName, (MojoFileInformationProvider)provider));
    }

    public void registerListener(BuilderContextListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(BuilderContextListener listener) {
        this.listeners.remove(listener);
    }
}

