/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.EntryDetails;
import java.io.File;

public class PackageEntry
extends EntryDetails {
    private String name;
    private Boolean directory;
    private File file;
    private Collector collect;
    private String linkTo;
    private String ruleset;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getDirectory() {
        return this.directory;
    }

    public void setDirectory(Boolean directory) {
        this.directory = directory;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Collector getCollect() {
        return this.collect;
    }

    public void setCollect(Collector collect) {
        this.collect = collect;
    }

    public void setLinkTo(String linkTo) {
        this.linkTo = linkTo;
    }

    public String getLinkTo() {
        return this.linkTo;
    }

    public void setRuleset(String ruleset) {
        this.ruleset = ruleset;
    }

    public String getRuleset() {
        return this.ruleset;
    }

    @Override
    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalStateException("'name' must not be empty");
        }
        int sources = 0;
        sources += this.directory != null && this.directory != false ? 1 : 0;
        sources += this.file != null ? 1 : 0;
        sources += this.collect != null ? 1 : 0;
        sources += this.linkTo != null ? 1 : 0;
        if ((sources += Boolean.TRUE.equals(this.getGhost()) ? 1 : 0) != 1) {
            throw new IllegalStateException("Exactly one of 'file', 'directory', 'linkTo', 'collect' or 'ghost' must be specified.");
        }
        super.validate();
    }

    public static class Collector {
        private File from;
        private boolean directories = true;
        private boolean symbolicLinks = false;
        private String[] includes;
        private String[] excludes;

        public File getFrom() {
            return this.from;
        }

        public void setFrom(File from) {
            this.from = from;
        }

        public void setDirectories(boolean directories) {
            this.directories = directories;
        }

        public boolean isDirectories() {
            return this.directories;
        }

        public void setSymbolicLinks(boolean symbolicLinks) {
            this.symbolicLinks = symbolicLinks;
        }

        public boolean isSymbolicLinks() {
            return this.symbolicLinks;
        }

        public void setIncludes(String[] includes) {
            this.includes = includes;
        }

        public String[] getIncludes() {
            return this.includes;
        }

        public void setExcludes(String[] excludes) {
            this.excludes = excludes;
        }

        public String[] getExcludes() {
            return this.excludes;
        }

        public String toString() {
            return String.format("[collector - from: %s,  directories: %s, symLinks: %s, includes: %s, excludes: %s]", this.from, this.directories, this.symbolicLinks, this.includes, this.excludes);
        }
    }
}

