/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import com.google.common.collect.Lists;
import de.dentrassi.rpm.builder.Logger;
import de.dentrassi.rpm.builder.Signature;
import de.dentrassi.rpm.builder.SigningHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.eclipse.packagedrone.utils.io.FileSystemSpoolOutTarget;
import org.eclipse.packagedrone.utils.io.SpoolOutTarget;
import org.eclipse.packagedrone.utils.rpm.HashAlgorithm;
import org.eclipse.packagedrone.utils.rpm.info.RpmInformation;
import org.eclipse.packagedrone.utils.rpm.info.RpmInformations;
import org.eclipse.packagedrone.utils.rpm.parse.RpmInputStream;
import org.eclipse.packagedrone.utils.rpm.yum.RepositoryCreator;
import org.eclipse.packagedrone.utils.security.pgp.SigningStream;

@Mojo(name="yum-repository", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=false)
public class YumMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="yum.repository.output", defaultValue="${project.build.directory}/yum")
    private File outputDirectory;
    @Parameter
    private List<File> files;
    @Parameter
    private List<File> directories;
    private File packagesPath;
    @Parameter(property="rpm.signature")
    private Signature signature;
    @Parameter(property="rpm.skipSigning", defaultValue="false")
    private boolean skipSigning = false;
    @Parameter(property="rpm.skipDependencies", defaultValue="false")
    private boolean skipDependencies = false;
    @Parameter(property="yum.skip", defaultValue="false")
    private boolean skip;
    private Logger logger;

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logger = new Logger(this.getLog());
        if (this.skip) {
            this.logger.debug("Skipping execution", new Object[0]);
            return;
        }
        try {
            PGPPrivateKey privateKey;
            RepositoryCreator.Builder builder = new RepositoryCreator.Builder();
            builder.setTarget((SpoolOutTarget)new FileSystemSpoolOutTarget(this.outputDirectory.toPath()));
            if (!this.skipSigning && (privateKey = SigningHelper.loadKey(this.signature, this.logger)) != null) {
                int digestAlgorithm = HashAlgorithm.from((String)this.signature.getHashAlgorithm()).getValue();
                builder.setSigning(output -> new SigningStream(output, privateKey, digestAlgorithm, false, "RPM builder Mojo - de.dentrassi.maven:rpm"));
            }
            RepositoryCreator creator = builder.build();
            this.packagesPath = new File(this.outputDirectory, "packages");
            Files.createDirectories(this.packagesPath.toPath(), new FileAttribute[0]);
            final ArrayList paths = Lists.newArrayList();
            if (!this.skipDependencies) {
                Set deps = this.project.getArtifacts();
                if (deps != null) {
                    paths.addAll(deps.stream().filter(d -> d.getType().equalsIgnoreCase("rpm")).map(d -> d.getFile().toPath()).collect(Collectors.toList()));
                }
            } else {
                this.logger.debug("Skipped RPM artifacts from maven dependencies", new Object[0]);
            }
            if (this.files != null) {
                paths.addAll(this.files.stream().map(f -> f.toPath()).collect(Collectors.toList()));
            }
            if (this.directories != null) {
                for (File dir : this.directories) {
                    Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (file.getFileName().toString().toLowerCase().endsWith(".rpm")) {
                                paths.add(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
            }
            this.addPackageList(creator, paths);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write repository", (Exception)e);
        }
    }

    private void addPackageList(RepositoryCreator creator, Collection<Path> paths) {
        try {
            creator.process(context -> {
                for (Path p : paths) {
                    this.addSinglePackage(p, (RepositoryCreator.Context)context);
                }
                this.getLog().info((CharSequence)String.format("Added %s packages to the repository", paths.size()));
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addSinglePackage(Path path, RepositoryCreator.Context context) throws IOException {
        RpmInformation rpmInformation;
        String checksum = this.makeChecksum(path);
        String fileName = path.getFileName().toString();
        String location = "packages/" + fileName;
        RepositoryCreator.FileInformation fileInformation = new RepositoryCreator.FileInformation(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant(), Files.size(path), location);
        try (RpmInputStream ris = new RpmInputStream(Files.newInputStream(path, new OpenOption[0]));){
            rpmInformation = RpmInformations.makeInformation((RpmInputStream)ris);
        }
        context.addPackage(fileInformation, rpmInformation, Collections.singletonMap(HashAlgorithm.SHA256, checksum), HashAlgorithm.SHA256);
        Files.copy(path, this.packagesPath.toPath().resolve(fileName), StandardCopyOption.COPY_ATTRIBUTES);
    }

    private String makeChecksum(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            String string = DigestUtils.sha256Hex((InputStream)is).toLowerCase();
            return string;
        }
    }
}

