/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import org.eclipse.packagedrone.utils.rpm.build.PayloadEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class When {
    private static final Logger logger = LoggerFactory.getLogger(When.class);
    private String type;
    private String prefix;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return String.format("[when - type: %s, prefix: %s]", this.type, this.prefix);
    }

    public boolean matches(Object object, PayloadEntryType type, String targetName) {
        if (this.prefix != null && !this.prefix.isEmpty() && !targetName.startsWith(this.prefix)) {
            logger.debug("Prefix is set and does not match - expected: '{}', provided: '{}'", (Object)this.prefix, (Object)targetName);
            return false;
        }
        if (this.type != null && !this.type.isEmpty()) {
            logger.debug("Testing type - expected: {}, actual: {}", (Object)this.type, (Object)type);
            switch (this.type.toLowerCase()) {
                case "directory": {
                    if (type == PayloadEntryType.DIRECTORY) break;
                    return false;
                }
                case "file": {
                    if (type == PayloadEntryType.FILE) break;
                    return false;
                }
                case "link": {
                    if (type == PayloadEntryType.SYMBOLIC_LINK) break;
                    return false;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown match type: '%s'", this.type));
                }
            }
        }
        logger.debug("Is a match");
        return true;
    }
}

