/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.maven.asyncapi;

import de.dentrassi.asyncapi.AsyncApi;
import de.dentrassi.asyncapi.ValidationException;
import de.dentrassi.asyncapi.Validator;
import de.dentrassi.asyncapi.generator.java.Generator;
import de.dentrassi.asyncapi.generator.java.GeneratorExtension;
import de.dentrassi.asyncapi.generator.java.gson.GsonGeneratorExtension;
import de.dentrassi.asyncapi.generator.java.jms.JmsClientGeneratorExtension;
import de.dentrassi.asyncapi.internal.parser.YamlParser;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true, threadSafe=false)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(property="asyncapi.definition", required=true, defaultValue="${project.basedir}/src/main/asyncapi.yaml")
    private File definitionFile;
    @Parameter(property="asyncapi.ignoreMissingDefinition", required=false, defaultValue="false")
    private boolean ignoreMissingDefinition;
    @Parameter(property="asyncapi.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="asyncapi.generator.charset", required=true, defaultValue="${project.build.sourceEncoding}")
    private String characterSet;
    @Parameter(property="asyncapi.generator.packageBase", required=false)
    private String packageBase;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/asyncapi")
    private File targetPath;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    private Set<String> extensions;
    @Component
    private BuildContext buildContext;

    public void setDefinitionFile(File definitionFile) {
        this.definitionFile = definitionFile;
    }

    public void setIgnoreMissingDefinition(boolean ignoreMissingDefinition) {
        this.ignoreMissingDefinition = ignoreMissingDefinition;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public void setPackageBase(String packageBase) {
        this.packageBase = packageBase;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setExtensions(Set<String> extensions) {
        this.extensions = extensions;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String version;
        AsyncApi api;
        if (this.skip) {
            return;
        }
        if (!this.definitionFile.exists() && this.ignoreMissingDefinition) {
            this.getLog().debug((CharSequence)String.format("Skipping. Definition file '%s' is missing but we ignore this", this.definitionFile));
            return;
        }
        this.getLog().info((CharSequence)String.format("Reading definition: %s", this.definitionFile));
        try (InputStream in = Files.newInputStream(this.definitionFile.toPath(), new OpenOption[0]);){
            api = new YamlParser(in).parse();
        }
        catch (ValidationException e) {
            this.getLog().error((CharSequence)"Model validation failed: ");
            for (Validator.Marker marker : e.getMarkers()) {
                this.getLog().error((CharSequence)marker.toString());
            }
            throw new MojoFailureException("Invalid API model", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to read definition", (Throwable)e);
        }
        String title = api.getInformation().getTitle();
        if (title == null) {
            title = "unknown";
        }
        if ((version = api.getInformation().getVersion()) == null) {
            version = "unknown";
        }
        this.getLog().info((CharSequence)String.format("Generating API: %s:%s", title, version));
        this.getLog().debug((CharSequence)String.format("    Output: %s", this.targetPath));
        Generator.Builder generator = Generator.newBuilder();
        generator.characterSet(Charset.forName(this.characterSet));
        generator.basePackage(this.packageBase);
        generator.targetPath(this.targetPath.toPath());
        this.addNamedExtensions(generator);
        try {
            generator.build(api).generate();
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to generate API", (Throwable)e);
        }
        this.project.addCompileSourceRoot(this.targetPath.getAbsolutePath());
        this.buildContext.refresh(this.targetPath.getAbsoluteFile());
    }

    private void addNamedExtensions(Generator.Builder generator) throws MojoExecutionException {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>(Arrays.asList("jms-client", "gson"));
            this.getLog().info((CharSequence)("Using default extensions: " + this.extensions));
        }
        block8: for (String extension : this.extensions) {
            switch (extension.toLowerCase()) {
                case "jms-client": {
                    generator.addExtension((GeneratorExtension)new JmsClientGeneratorExtension());
                    continue block8;
                }
                case "gson": {
                    generator.addExtension((GeneratorExtension)new GsonGeneratorExtension());
                    continue block8;
                }
            }
            throw new MojoExecutionException(String.format("Unknown generator extension '%s'", extension));
        }
    }
}

