/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.init;

import java.util.ServiceLoader;
import org.eclipse.scada.utils.init.Initializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoaderProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLoaderProcessor.class);

    private ServiceLoaderProcessor() {
    }

    public static void initialize(Object type) {
        ServiceLoaderProcessor.initialize(type, null);
    }

    public static void initialize(Object type, ClassLoader classloader) {
        logger.debug("Initializing: {}", type);
        ServiceLoader<Initializer> loader = ServiceLoader.load(Initializer.class, classloader);
        for (Initializer initializer : loader) {
            logger.debug("Processing: {}", (Object)initializer);
            try {
                initializer.initialize(type);
            }
            catch (Exception e) {
                logger.info("Failed to initialize", e);
            }
        }
    }
}

