/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent;

import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IteratingFuture<T, S>
extends AbstractFuture<T> {
    private static final Logger logger = LoggerFactory.getLogger(IteratingFuture.class);
    private final Iterator<? extends S> iterator;
    private S current;
    private volatile NotifyFuture<T> currentFuture;
    private boolean canceled;

    public IteratingFuture(Iterable<? extends S> iterable) {
        this.iterator = iterable.iterator();
    }

    public IteratingFuture<T, S> startIterating() {
        this.processNext();
        return this;
    }

    protected void processCurrent() {
        try {
            this.process(this.perform(this.current));
        }
        catch (Exception e) {
            logger.debug("Failed to process current", e);
            this.setError(e);
        }
    }

    protected void processNext() {
        try {
            this.process(this.next());
        }
        catch (Exception e) {
            logger.debug("Failed to process next", e);
            this.setError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(NotifyFuture<T> future) {
        IteratingFuture iteratingFuture = this;
        synchronized (iteratingFuture) {
            if (this.canceled) {
                future.cancel(true);
                throw new CancellationException();
            }
            this.currentFuture = future;
        }
        future.addListener(new FutureListenerImpl(this.current));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        NotifyFuture<T> current;
        IteratingFuture iteratingFuture = this;
        synchronized (iteratingFuture) {
            this.canceled = true;
            current = this.currentFuture;
        }
        if (current != null) {
            current.cancel(mayInterruptIfRunning);
        }
        return super.cancel(mayInterruptIfRunning);
    }

    private NotifyFuture<T> next() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            return this.perform(this.current);
        }
        this.current = null;
        return this.last();
    }

    protected void doComplete(Future<T> future, S current) throws Exception {
        this.currentFuture = null;
        this.handleComplete(future, current);
    }

    protected abstract void handleComplete(Future<T> var1, S var2) throws Exception;

    protected abstract NotifyFuture<T> perform(S var1);

    protected abstract NotifyFuture<T> last();

    public final class FutureListenerImpl
    implements FutureListener<T> {
        private final S current;

        public FutureListenerImpl(S current) {
            this.current = current;
        }

        @Override
        public void complete(Future<T> future) {
            try {
                IteratingFuture.this.doComplete(future, this.current);
            }
            catch (Exception e) {
                logger.debug("Failed to complete", e);
                IteratingFuture.this.setError(e);
            }
        }
    }
}

