/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountingThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CountingThreadPoolExecutor.class);
    private final Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    public CountingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public CountingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public CountingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public CountingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void fireCountChanged(int count) {
        for (Listener listener : this.listeners) {
            try {
                listener.countChanged(count);
            }
            catch (Exception e) {
                logger.info("Failed to fireCountChanged", e);
            }
        }
    }

    protected void updateCount() {
        this.fireCountChanged(this.getQueue().size());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.updateCount();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.updateCount();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> result = super.shutdownNow();
        this.updateCount();
        return result;
    }

    @Override
    public boolean remove(Runnable task) {
        boolean result = super.remove(task);
        this.updateCount();
        return result;
    }

    @Override
    public Future<?> submit(Runnable task) {
        Future<?> result = super.submit(task);
        this.updateCount();
        return result;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Future<T> resultValue = super.submit(task, result);
        this.updateCount();
        return resultValue;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Future<T> result = super.submit(task);
        this.updateCount();
        return result;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Object result = super.invokeAny(tasks);
        this.updateCount();
        return result;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = super.invokeAny(tasks, timeout, unit);
        this.updateCount();
        return result;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List result = super.invokeAll(tasks);
        this.updateCount();
        return result;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List result = super.invokeAll(tasks, timeout, unit);
        this.updateCount();
        return result;
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
        this.updateCount();
    }

    public static interface Listener {
        public void countChanged(int var1);
    }
}

